/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-04-28 06:09:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wpeps_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=25933 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=32863 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=77477 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_cmplz_cookiebanners` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `banner_version` int NOT NULL,
  `default` int NOT NULL,
  `position` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `checkbox_style` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_logo` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `logo_attachment_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `close_button` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `revoke` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `manage_consent_options` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dismiss` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `save_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `view_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_functional` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_all` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_stats` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_prefs` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optin` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_categories` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `disable_cookiebanner` int NOT NULL,
  `banner_width` int NOT NULL,
  `soft_cookiewall` int NOT NULL,
  `dismiss_on_scroll` int NOT NULL,
  `dismiss_on_timeout` int NOT NULL,
  `dismiss_timeout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept_informational` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_custom_cookie_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `functional_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text_anonymous` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `preferences_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `marketing_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_background` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_toggles` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `border_width` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `font_size` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_deny` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `buttons_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `animation` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_box_shadow` int NOT NULL,
  `header_footer_shadow` int NOT NULL,
  `hide_preview` int NOT NULL,
  `disable_width_correction` int NOT NULL,
  `legal_documents` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_cmplz_cookies` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sync` int NOT NULL,
  `ignored` int NOT NULL,
  `retention` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceID` int NOT NULL,
  `cookieFunction` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collectedPersonalData` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `purpose` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `isOwnDomainCookie` int NOT NULL,
  `domain` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `deleted` int NOT NULL,
  `isMembersOnly` int NOT NULL,
  `showOnPolicy` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  `lastAddDate` int NOT NULL,
  `firstAddDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_cmplz_dnsmpd` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `region` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `global_optout` int NOT NULL,
  `cross_context` int NOT NULL,
  `limit_sensitive` int NOT NULL,
  `request_for_access` int NOT NULL,
  `right_to_be_forgotten` int NOT NULL,
  `right_to_data_portability` int NOT NULL,
  `request_date` int NOT NULL,
  `resolved` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_cmplz_services` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceType` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thirdParty` int NOT NULL,
  `sharesData` int NOT NULL,
  `secondParty` int NOT NULL,
  `privacyStatementURL` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `sync` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_bans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'ip',
  `created_at` datetime NOT NULL,
  `actor_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `actor_id` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `host` (`host`),
  KEY `actor` (`actor_type`,`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_dashboard_events` (
  `event_id` int unsigned NOT NULL AUTO_INCREMENT,
  `event_slug` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_time` datetime NOT NULL,
  `event_count` int unsigned NOT NULL DEFAULT '1',
  `event_consolidated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `event_slug__time__consolidated` (`event_slug`,`event_time`,`event_consolidated`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_dashboard_lockouts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time` datetime NOT NULL,
  `count` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip__time` (`ip`,`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_distributed_storage` (
  `storage_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `storage_chunk` int NOT NULL DEFAULT '0',
  `storage_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_fingerprints` (
  `fingerprint_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint unsigned NOT NULL,
  `fingerprint_hash` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_snapshot` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_uuid` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_firewall_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `provider` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `provider_ref` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vulnerability` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `config` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `paused_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `provider__ref` (`provider`,`provider_ref`),
  KEY `vulnerability` (`vulnerability`),
  KEY `paused_at` (`paused_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_geolocation_cache` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_credit` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_time` datetime NOT NULL,
  `location_meta` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_lockouts` (
  `lockout_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_user` bigint unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_active` int NOT NULL DEFAULT '1',
  `lockout_context` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `init_timestamp` (`init_timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=420 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_mutexes` (
  `mutex_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `mutex_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mutex_expires` int unsigned NOT NULL,
  PRIMARY KEY (`mutex_id`),
  UNIQUE KEY `mutex_name` (`mutex_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_opaque_tokens` (
  `token_id` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_hashed` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_temp` (
  `temp_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `temp_user` bigint unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_user_groups` (
  `group_id` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `group_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `group_roles` text COLLATE utf8mb4_unicode_520_ci,
  `group_canonical` text COLLATE utf8mb4_unicode_520_ci,
  `group_users` text COLLATE utf8mb4_unicode_520_ci,
  `group_min_role` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_vulnerabilities` (
  `id` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `software_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `software_slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `first_seen` datetime NOT NULL,
  `last_seen` datetime NOT NULL,
  `resolved_at` datetime DEFAULT NULL,
  `resolved_by` bigint unsigned NOT NULL DEFAULT '0',
  `resolution` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `resolution` (`resolution`),
  KEY `software_type` (`software_type`),
  KEY `last_seen` (`last_seen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_webauthn_credentials` (
  `ref` char(64) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `id` varchar(1024) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `transports` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `public_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sign_count` bigint unsigned NOT NULL,
  `backup_eligible` tinyint unsigned NOT NULL,
  `backed_up` tinyint unsigned NOT NULL,
  `webauthn_user` char(44) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `trashed_at` datetime DEFAULT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ref`),
  KEY `webauthn_user__status` (`webauthn_user`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_itsec_webauthn_users` (
  `user_id` bigint unsigned NOT NULL,
  `webauthn_id` char(44) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_action_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_actions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `active` tinyint(1) DEFAULT '1',
  `parent_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `label` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_chunks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_field_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `label` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `parent_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `field_label` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `order` int DEFAULT NULL,
  `required` bit(1) DEFAULT NULL,
  `default_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `label_pos` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `personally_identifiable` bit(1) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_form_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_forms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `views` int DEFAULT NULL,
  `subs` int DEFAULT NULL,
  `form_title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `default_label_pos` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `show_title` bit(1) DEFAULT NULL,
  `clear_complete` bit(1) DEFAULT NULL,
  `hide_complete` bit(1) DEFAULT NULL,
  `logged_in` bit(1) DEFAULT NULL,
  `seq_num` int DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_object_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL,
  `key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_key` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_objects` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `object_title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_relationships` (
  `id` int NOT NULL AUTO_INCREMENT,
  `child_id` int NOT NULL,
  `child_type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` int NOT NULL,
  `parent_type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_nf3_upgrades` (
  `id` int NOT NULL,
  `cache` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `stage` int NOT NULL DEFAULT '0',
  `maintenance` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wpeps_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=84664 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3252 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=391 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woof_query_cache` (
  `mkey` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mvalue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`mkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woof_sd` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'checkbox',
  `template` int DEFAULT '0',
  `demo_taxonomy` varchar(96) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_woof_sd_presets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'checkbox',
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wpr_above_the_fold` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `lcp` longtext COLLATE utf8mb4_unicode_520_ci,
  `viewport` longtext COLLATE utf8mb4_unicode_520_ci,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wpr_lazy_render_content` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `below_the_fold` longtext COLLATE utf8mb4_unicode_520_ci,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB AUTO_INCREMENT=999 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wpr_rocket_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=618 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_wpr_rucss_used_css` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `css` longtext COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `error_code` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `unprocessedcss` longtext COLLATE utf8mb4_unicode_520_ci,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `queue_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=1023 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wpeps_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpeps_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wpeps_users` VALUES 
("1","Wp-Eps@81","$P$Bf9kjfvFR81AxzX8ot9/LYs.QFEqAn.","wp-eps81","contact@elegance-piscines-spas.com","https://elegance-piscines-spas.com","2024-12-02 15:01:22","","0","Wp-Eps@81"),
("2","ANS-Eps@81","$wp$2y$10$1CBWrrSs.aVS3AWKUKJ4Puqs8w96spFgR.rDzOhuV4KNy.x2U3r3u","ans-eps81","contact@anewstory.fr","","2025-01-15 11:00:43","","0","ANS-Eps@81");

INSERT IGNORE INTO `wpeps_usermeta` VALUES 
("1","1","nickname","Wp-Eps@81"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wpeps_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wpeps_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","1"),
("17","1","wpeps_dashboard_quick_press_last_post_id","3226"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"90.85.237.0\";}"),
("19","1","wpeps_user-settings","libraryContent=browse&imgsize=&editor=html"),
("20","1","wpeps_user-settings-time","1735657421"),
("21","1","wpeps_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:0;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-01-07T08:43:26.593Z\";}"),
("22","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("23","1","metaboxhidden_nav-menus","a:6:{i:0;s:21:\"add-post-type-project\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:20:\"add-project_category\";i:4;s:15:\"add-project_tag\";i:5;s:22:\"add-gallery_categories\";}"),
("24","1","nav_menu_recently_edited","3"),
("31","1","_woocommerce_tracks_anon_id","woo:xJ0g4iEZxmXD8KbGoVuLQ1fb"),
("32","1","wc_last_active","1743465600"),
("33","1","meta-box-order_product","a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:129:\"et_settings_meta_box,submitdiv,postimagediv,woocommerce-product-images,acf-group_675c07b3e1af5,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:84:\"acf-group_675c0812c09eb,woocommerce-product-data,,,,,slugdiv,postexcerpt,commentsdiv\";s:8:\"advanced\";s:0:\"\";}"),
("35","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("39","1","wpeps_woocommerce_product_import_mapping","a:29:{i:0;s:2:\"id\";i:1;s:4:\"type\";i:2;s:4:\"name\";i:3;s:6:\"images\";i:4;s:25:\"meta:_et_pb_post_hide_nav\";i:5;s:23:\"meta:_et_pb_page_layout\";i:6;s:20:\"meta:_et_pb_side_nav\";i:7;s:24:\"meta:image_produit_coque\";i:8;s:25:\"meta:_image_produit_coque\";i:9;s:23:\"meta:_et_pb_use_builder\";i:10;s:23:\"meta:_et_pb_first_image\";i:11;s:25:\"meta:_et_pb_truncate_post\";i:12;s:30:\"meta:_et_pb_truncate_post_date\";i:13;s:23:\"meta:_et_pb_old_content\";i:14;s:30:\"meta:_et_pb_show_page_creation\";i:15;s:31:\"meta:_et_pb_built_for_post_type\";i:16;s:23:\"meta:_et_pb_ab_subjects\";i:17;s:37:\"meta:_et_pb_enable_shortcode_tracking\";i:18;s:32:\"meta:_et_pb_ab_current_shortcode\";i:19;s:22:\"meta:_et_pb_custom_css\";i:20;s:24:\"meta:_et_pb_gutter_width\";i:21;s:24:\"meta:_global_colors_info\";i:22;s:31:\"meta:_et_pb_product_page_layout\";i:23;s:24:\"meta:_et_builder_version\";i:24;s:35:\"meta:_et_pb_woo_page_content_status\";i:25;s:22:\"meta:caracteristiques_\";i:26;s:23:\"meta:_caracteristiques_\";i:27;s:12:\"meta:options\";i:28;s:13:\"meta:_options\";}"),
("40","1","wpeps_product_import_error_log","a:0:{}"),
("44","1","closedpostboxes_acf-field-group","a:0:{}"),
("45","1","metaboxhidden_acf-field-group","a:1:{i:0;s:7:\"slugdiv\";}"),
("46","1","screen_layout_product","2"),
("56","1","last_update","1736239408"),
("69","1","edit_product_per_page","27"),
("73","2","nickname","ANS-Eps@81"),
("74","2","first_name",""),
("75","2","last_name",""),
("76","2","description",""),
("77","2","rich_editing","true"),
("78","2","syntax_highlighting","true"),
("79","2","comment_shortcuts","false"),
("80","2","admin_color","fresh"),
("81","2","use_ssl","0"),
("82","2","show_admin_bar_front","true"),
("83","2","locale",""),
("84","2","wpeps_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("85","2","wpeps_user_level","10"),
("86","2","dismissed_wp_pointers","theme_editor_notice"),
("87","2","last_update","1741622972"),
("89","2","wc_last_active","1745539200"),
("91","2","_woocommerce_tracks_anon_id","woo:n5AS2NsJpvWQedtKVrmPfaOz"),
("92","2","wpeps_dashboard_quick_press_last_post_id","3246"),
("93","2","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("94","2","community-events-location","a:1:{s:2:\"ip\";s:12:\"176.133.24.0\";}"),
("97","2","wpeps_user-settings","imgsize=full&libraryContent=browse&editor=tinymce"),
("98","2","wpeps_user-settings-time","1745584085"),
("99","2","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("104","2","wpeps_media_library_mode","grid"),
("105","2","upload_per_page","162"),
("106","2","wpeps_persisted_preferences","a:4:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:9:\"_modified\";s:24:\"2025-03-10T16:09:31.934Z\";s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:17:\"core/edit-widgets\";a:2:{s:26:\"isComplementaryAreaVisible\";b:0;s:12:\"welcomeGuide\";b:0;}}"),
("126","2","wpeps_woocommerce_product_import_mapping","a:89:{i:0;s:2:\"id\";i:1;s:4:\"type\";i:2;s:3:\"sku\";i:3;s:0:\"\";i:4;s:4:\"name\";i:5;s:9:\"published\";i:6;s:8:\"featured\";i:7;s:18:\"catalog_visibility\";i:8;s:17:\"short_description\";i:9;s:11:\"description\";i:10;s:17:\"date_on_sale_from\";i:11;s:15:\"date_on_sale_to\";i:12;s:10:\"tax_status\";i:13;s:9:\"tax_class\";i:14;s:12:\"stock_status\";i:15;s:14:\"stock_quantity\";i:16;s:16:\"low_stock_amount\";i:17;s:10:\"backorders\";i:18;s:17:\"sold_individually\";i:19;s:6:\"weight\";i:20;s:6:\"length\";i:21;s:5:\"width\";i:22;s:6:\"height\";i:23;s:15:\"reviews_allowed\";i:24;s:13:\"purchase_note\";i:25;s:10:\"sale_price\";i:26;s:13:\"regular_price\";i:27;s:12:\"category_ids\";i:28;s:7:\"tag_ids\";i:29;s:17:\"shipping_class_id\";i:30;s:6:\"images\";i:31;s:14:\"download_limit\";i:32;s:15:\"download_expiry\";i:33;s:9:\"parent_id\";i:34;s:16:\"grouped_products\";i:35;s:10:\"upsell_ids\";i:36;s:14:\"cross_sell_ids\";i:37;s:11:\"product_url\";i:38;s:11:\"button_text\";i:39;s:10:\"menu_order\";i:40;s:9:\"brand_ids\";i:41;s:16:\"attributes:name1\";i:42;s:17:\"attributes:value1\";i:43;s:19:\"attributes:visible1\";i:44;s:20:\"attributes:taxonomy1\";i:45;s:16:\"attributes:name2\";i:46;s:17:\"attributes:value2\";i:47;s:19:\"attributes:visible2\";i:48;s:20:\"attributes:taxonomy2\";i:49;s:16:\"attributes:name3\";i:50;s:17:\"attributes:value3\";i:51;s:19:\"attributes:visible3\";i:52;s:20:\"attributes:taxonomy3\";i:53;s:16:\"attributes:name4\";i:54;s:17:\"attributes:value4\";i:55;s:19:\"attributes:visible4\";i:56;s:20:\"attributes:taxonomy4\";i:57;s:16:\"attributes:name5\";i:58;s:17:\"attributes:value5\";i:59;s:19:\"attributes:visible5\";i:60;s:20:\"attributes:taxonomy5\";i:61;s:16:\"attributes:name6\";i:62;s:17:\"attributes:value6\";i:63;s:19:\"attributes:visible6\";i:64;s:20:\"attributes:taxonomy6\";i:65;s:16:\"attributes:name7\";i:66;s:17:\"attributes:value7\";i:67;s:19:\"attributes:visible7\";i:68;s:20:\"attributes:taxonomy7\";i:69;s:16:\"attributes:name8\";i:70;s:17:\"attributes:value8\";i:71;s:19:\"attributes:visible8\";i:72;s:20:\"attributes:taxonomy8\";i:73;s:16:\"attributes:name9\";i:74;s:17:\"attributes:value9\";i:75;s:19:\"attributes:visible9\";i:76;s:20:\"attributes:taxonomy9\";i:77;s:17:\"attributes:name10\";i:78;s:18:\"attributes:value10\";i:79;s:20:\"attributes:visible10\";i:80;s:21:\"attributes:taxonomy10\";i:81;s:17:\"attributes:name11\";i:82;s:18:\"attributes:value11\";i:83;s:20:\"attributes:visible11\";i:84;s:21:\"attributes:taxonomy11\";i:85;s:17:\"attributes:name12\";i:86;s:18:\"attributes:value12\";i:87;s:20:\"attributes:visible12\";i:88;s:21:\"attributes:taxonomy12\";}"),
("127","2","wpeps_product_import_error_log","a:0:{}"),
("136","2","nav_menu_recently_edited","3"),
("137","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("138","2","metaboxhidden_nav-menus","a:9:{i:0;s:21:\"add-post-type-project\";i:1;s:21:\"add-post-type-product\";i:2;s:12:\"add-post_tag\";i:3;s:15:\"add-post_format\";i:4;s:20:\"add-project_category\";i:5;s:15:\"add-project_tag\";i:6;s:15:\"add-product_cat\";i:7;s:15:\"add-product_tag\";i:8;s:22:\"add-gallery_categories\";}"),
("141","2","edit_product_per_page","33"),
("180","2","session_tokens","a:1:{s:64:\"f1ceb3d56caa79fd541c588e2763673700d24807bf01c70a475fd5ce8cde3fb9\";a:4:{s:10:\"expiration\";i:1745755978;s:2:\"ip\";s:13:\"176.133.24.92\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";s:5:\"login\";i:1745583178;}}"),
("185","2","itsec_user_activity_last_seen","1745583196"),
("186","2","itsec-password-strength","4"),
("187","2","_itsec_password_requirements","a:1:{s:16:\"evaluation_times\";a:1:{s:8:\"strength\";i:1743671048;}}"),
("189","2","_itsec_has_logged_in","1743671048"),
("191","2","rocket_boxes","a:2:{i:0;s:34:\"rocket_warning_plugin_modification\";i:1;s:14:\"preload_notice\";}"),
("204","2","wpeps_yoast_notifications","a:1:{i:0;a:2:{s:7:\"message\";s:517:\"Il semblerait que vous n’utilisez pas notre <strong>module Yoast WooCommerce SEO</strong>. <a href=\"https://yoa.st/1o0?php_version=7.4&platform=wordpress&platform_version=6.8&software=free&software_version=24.8.1&days_active=18&user_language=fr_FR&screen=wprocket\" aria-label=\"Plus d’informations au sujet de Yoast WooCommerce SEO\" target=\"_blank\" rel=\"noopener noreferrer\">Achetez-le</a> et débloquez plus d’outils et de fonctionnalités SEO pour mettre en avant vos produits dans les résultats de recherche.\";s:7:\"options\";a:10:{s:4:\"type\";s:7:\"warning\";s:2:\"id\";s:44:\"wpseo-suggested-plugin-yoast-woocommerce-seo\";s:7:\"user_id\";i:2;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";a:1:{i:0;s:15:\"install_plugins\";}s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;}}}"),
("205","2","_yoast_wpseo_introductions","a:1:{s:25:\"ai-fix-assessments-upsell\";b:1;}"),
("207","2","_yoast_wpseo_profile_updated","1744100843"),
("208","1","_yoast_wpseo_profile_updated","1744100843");

INSERT IGNORE INTO `wpeps_actionscheduler_actions` VALUES 
("172","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2024-12-12 13:11:04","2024-12-12 13:11:04","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-12-12 13:11:26","2024-12-12 14:11:26","0",NULL),
("272","action_scheduler/migration_hook","failed","2024-12-13 09:53:46","2024-12-13 10:53:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734083626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734083626;}","1","1","2024-12-13 09:54:47","2024-12-13 10:54:47","0",NULL),
("1182","woocommerce_cleanup_draft_orders","complete","2025-03-28 10:27:07","2025-03-28 11:27:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743157627;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743157627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-03-28 14:45:53","2025-03-28 15:45:53","0",NULL),
("1217","woocommerce_cleanup_draft_orders","complete","2025-03-29 14:45:53","2025-03-29 15:45:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743259553;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743259553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-03-29 16:35:15","2025-03-29 17:35:15","0",NULL),
("1218","woocommerce_cleanup_draft_orders","complete","2025-03-30 16:35:15","2025-03-30 18:35:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743352515;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743352515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-03-31 09:22:28","2025-03-31 11:22:28","0",NULL),
("1219","woocommerce_cleanup_draft_orders","complete","2025-04-01 09:22:28","2025-04-01 11:22:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743499348;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743499348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-01 09:22:41","2025-04-01 11:22:41","0",NULL),
("1220","woocommerce_cleanup_draft_orders","complete","2025-04-02 09:22:41","2025-04-02 11:22:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743585761;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743585761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-02 09:27:28","2025-04-02 11:27:28","0",NULL),
("1221","woocommerce_cleanup_draft_orders","complete","2025-04-03 09:27:28","2025-04-03 11:27:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743672448;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743672448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-03 09:27:48","2025-04-03 11:27:48","0",NULL),
("1337","woocommerce_cleanup_draft_orders","complete","2025-04-04 09:27:48","2025-04-04 11:27:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743758868;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743758868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-04 09:29:44","2025-04-04 11:29:44","0",NULL),
("2281","woocommerce_cleanup_draft_orders","complete","2025-04-05 09:29:44","2025-04-05 11:29:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743845384;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743845384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-05 09:32:16","2025-04-05 11:32:16","0",NULL),
("2792","woocommerce_cleanup_draft_orders","complete","2025-04-06 09:32:16","2025-04-06 11:32:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743931936;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743931936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-06 09:57:54","2025-04-06 11:57:54","0",NULL),
("3255","woocommerce_cleanup_draft_orders","complete","2025-04-07 09:57:54","2025-04-07 11:57:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744019874;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744019874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-07 10:06:33","2025-04-07 12:06:33","0",NULL),
("3667","woocommerce_cleanup_draft_orders","complete","2025-04-08 10:06:33","2025-04-08 12:06:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744106793;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744106793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-08 10:07:15","2025-04-08 12:07:15","0",NULL),
("4269","woocommerce_cleanup_draft_orders","complete","2025-04-09 10:07:15","2025-04-09 12:07:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744193235;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744193235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-09 10:14:04","2025-04-09 12:14:04","0",NULL),
("6274","woocommerce_cleanup_draft_orders","complete","2025-04-10 10:14:04","2025-04-10 12:14:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744280044;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744280044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-10 10:14:08","2025-04-10 12:14:08","0",NULL),
("7825","woocommerce_cleanup_draft_orders","complete","2025-04-11 10:14:08","2025-04-11 12:14:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744366448;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744366448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-11 10:14:08","2025-04-11 12:14:08","0",NULL),
("8928","woocommerce_cleanup_draft_orders","complete","2025-04-12 10:14:08","2025-04-12 12:14:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744452848;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744452848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-12 10:16:50","2025-04-12 12:16:50","0",NULL),
("9898","woocommerce_cleanup_draft_orders","complete","2025-04-13 10:16:50","2025-04-13 12:16:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744539410;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744539410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-13 10:21:15","2025-04-13 12:21:15","0",NULL),
("10766","woocommerce_cleanup_draft_orders","complete","2025-04-14 10:21:15","2025-04-14 12:21:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744626075;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744626075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-14 10:24:22","2025-04-14 12:24:22","0",NULL),
("11756","woocommerce_cleanup_draft_orders","complete","2025-04-15 10:24:22","2025-04-15 12:24:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744712662;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744712662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-15 10:26:02","2025-04-15 12:26:02","0",NULL),
("12714","woocommerce_cleanup_draft_orders","complete","2025-04-16 10:26:02","2025-04-16 12:26:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744799162;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744799162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-16 10:54:25","2025-04-16 12:54:25","0",NULL),
("13729","woocommerce_cleanup_draft_orders","complete","2025-04-17 10:54:25","2025-04-17 12:54:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744887265;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744887265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-17 10:57:02","2025-04-17 12:57:02","0",NULL),
("15011","woocommerce_cleanup_draft_orders","complete","2025-04-18 10:57:02","2025-04-18 12:57:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744973822;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744973822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-18 10:57:30","2025-04-18 12:57:30","0",NULL),
("16018","woocommerce_cleanup_draft_orders","complete","2025-04-19 10:57:30","2025-04-19 12:57:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745060250;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745060250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-19 10:57:35","2025-04-19 12:57:35","0",NULL),
("16939","woocommerce_cleanup_draft_orders","complete","2025-04-20 10:57:36","2025-04-20 12:57:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745146656;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745146656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-20 10:58:06","2025-04-20 12:58:06","0",NULL),
("17864","woocommerce_cleanup_draft_orders","complete","2025-04-21 10:58:06","2025-04-21 12:58:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745233086;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745233086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-21 11:04:19","2025-04-21 13:04:19","0",NULL),
("18777","woocommerce_cleanup_draft_orders","complete","2025-04-22 11:04:19","2025-04-22 13:04:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745319859;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745319859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-22 11:05:40","2025-04-22 13:05:40","0",NULL),
("19726","woocommerce_cleanup_draft_orders","complete","2025-04-23 11:05:40","2025-04-23 13:05:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745406340;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745406340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-23 11:06:14","2025-04-23 13:06:14","0",NULL),
("20791","woocommerce_cleanup_draft_orders","complete","2025-04-24 11:06:14","2025-04-24 13:06:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745492774;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745492774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-24 11:42:45","2025-04-24 13:42:45","0",NULL),
("21951","woocommerce_cleanup_draft_orders","complete","2025-04-25 11:42:45","2025-04-25 13:42:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745581365;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745581365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-25 11:44:16","2025-04-25 13:44:16","0",NULL),
("23036","woocommerce_cleanup_draft_orders","complete","2025-04-26 11:44:16","2025-04-26 13:44:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745667856;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745667856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-26 12:08:35","2025-04-26 14:08:35","0",NULL),
("24185","woocommerce_cleanup_draft_orders","complete","2025-04-27 12:08:35","2025-04-27 14:08:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745755715;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745755715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-04-27 12:41:09","2025-04-27 14:41:09","0",NULL),
("25189","woocommerce_cleanup_draft_orders","pending","2025-04-28 12:41:09","2025-04-28 14:41:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745844069;s:18:\"\0*\0first_timestamp\";i:1733925420;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745844069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("25900","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/a-propos\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:24","2025-04-28 07:12:24","0",NULL),
("25901","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/a-propos\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:26","2025-04-28 07:12:26","0",NULL),
("25902","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/categorie\\/piscine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:29","2025-04-28 07:12:29","0",NULL),
("25903","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/categorie\\/piscine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:31","2025-04-28 07:12:31","0",NULL),
("25904","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/entretien-piscine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:35","2025-04-28 07:12:35","0",NULL),
("25905","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/entretien-piscine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:36","2025-04-28 07:12:36","0",NULL),
("25906","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/securite\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:39","2025-04-28 07:12:39","0",NULL),
("25907","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/securite\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:40","2025-04-28 07:12:40","0",NULL),
("25908","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/spas-et-equipements-bien-etre\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:12:42","2025-04-28 07:12:42","0",NULL),
("25909","rocket_preload_job_preload_url","complete","2025-04-28 05:10:55","2025-04-28 05:10:55","10","[\"https:\\/\\/elegance-piscines-spas.com\\/spas-et-equipements-bien-etre\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:01","2025-04-28 07:14:01","0",NULL),
("25910","rocket_preload_job_preload_url","complete","2025-04-28 05:11:16","2025-04-28 05:11:16","10","[\"https:\\/\\/elegance-piscines-spas.com\\/entretien-spa\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:05","2025-04-28 07:14:05","0",NULL),
("25911","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/temoignages\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:08","2025-04-28 07:14:08","0",NULL),
("25912","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/categorie\\/spa\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:10","2025-04-28 07:14:10","0",NULL),
("25913","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/categorie\\/sauna\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:13","2025-04-28 07:14:13","0",NULL),
("25914","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/categorie\\/bain-nordique\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:13","2025-04-28 07:14:13","0",NULL),
("25915","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/mentions-legales\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:16","2025-04-28 07:14:16","0",NULL),
("25916","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/politique-de-confidentialite\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:19","2025-04-28 07:14:19","0",NULL),
("25917","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/podestat\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:22","2025-04-28 07:14:22","0",NULL),
("25918","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/spa\\/spa_classique\\/everest\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:14:25","2025-04-28 07:14:25","0",NULL),
("25919","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/spa\\/spa_classique\\/lima\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:25","2025-04-28 07:22:25","0",NULL),
("25920","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/boutique\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:28","2025-04-28 07:22:28","0",NULL),
("25921","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/figerolle\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:31","2025-04-28 07:22:31","0",NULL),
("25922","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/callelongue\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:34","2025-04-28 07:22:34","0",NULL),
("25923","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/port-cros\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:37","2025-04-28 07:22:37","0",NULL),
("25924","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/elegance-85\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:22:40","2025-04-28 07:22:40","0",NULL),
("25925","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/sugiton\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:24:04","2025-04-28 07:24:04","0",NULL),
("25926","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/prado-plage\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:34:25","2025-04-28 07:34:25","0",NULL),
("25927","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/auron\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:00","2025-04-28 07:38:00","0",NULL),
("25928","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/mini-carre\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:03","2025-04-28 07:38:03","0",NULL),
("25929","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/mini\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:06","2025-04-28 07:38:06","0",NULL),
("25930","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/couloir-gp\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:09","2025-04-28 07:38:09","0",NULL),
("25931","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/bendor\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:12","2025-04-28 07:38:12","0",NULL),
("25932","rocket_preload_job_preload_url","complete","2025-04-28 05:12:42","2025-04-28 05:12:42","10","[\"https:\\/\\/elegance-piscines-spas.com\\/catalogue\\/piscine\\/elegance-xl\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2025-04-28 05:38:15","2025-04-28 07:38:15","0",NULL);

INSERT IGNORE INTO `wpeps_actionscheduler_claims` VALUES 
("13305","2025-04-07 13:34:44"),
("13315","2025-04-07 13:43:16"),
("14004","2025-04-08 12:18:15"),
("14261","2025-04-08 17:03:46"),
("14306","2025-04-08 17:18:54"),
("19694","2025-04-12 22:47:42"),
("23774","2025-04-17 10:47:07"),
("26506","2025-04-20 06:09:10"),
("27352","2025-04-21 06:12:51"),
("28362","2025-04-22 17:24:25"),
("29298","2025-04-23 21:18:30");

INSERT IGNORE INTO `wpeps_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","woocommerce-db-updates"),
("4","wc-admin-data"),
("5","wc_update_product_default_cat"),
("6","woocommerce-remote-inbox-engine"),
("7","rocket-preload"),
("8","rocket-rucss");

INSERT IGNORE INTO `wpeps_actionscheduler_logs` VALUES 
("8","172","action créée","2024-12-12 13:11:05","2024-12-12 14:11:05"),
("13","172","action lancée via Async Request","2024-12-12 13:11:26","2024-12-12 14:11:26"),
("14","172","échec de l’action via Async Request : L’action planifiée pour woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications ne sera pas exécutée car aucun rappel n’est enregistré.","2024-12-12 13:11:26","2024-12-12 14:11:26"),
("308","272","action créée","2024-12-13 09:52:46","2024-12-13 10:52:46"),
("309","272","action lancée via WP Cron","2024-12-13 09:54:47","2024-12-13 10:54:47"),
("310","272","échec de l’action via WP Cron : L’action planifiée pour action_scheduler/migration_hook ne sera pas exécutée car aucun rappel n’est enregistré.","2024-12-13 09:54:47","2024-12-13 10:54:47"),
("3040","1182","action créée","2025-03-27 10:27:07","2025-03-27 11:27:07"),
("3143","1182","action commencée via WP Cron","2025-03-28 14:45:53","2025-03-28 15:45:53"),
("3144","1182","action terminée via WP Cron","2025-03-28 14:45:53","2025-03-28 15:45:53"),
("3145","1217","action créée","2025-03-28 14:45:53","2025-03-28 15:45:53"),
("3146","1217","action commencée via WP Cron","2025-03-29 16:35:15","2025-03-29 17:35:15"),
("3147","1217","action terminée via WP Cron","2025-03-29 16:35:15","2025-03-29 17:35:15"),
("3148","1218","action créée","2025-03-29 16:35:15","2025-03-29 17:35:15"),
("3149","1218","action commencée via WP Cron","2025-03-31 09:22:28","2025-03-31 11:22:28"),
("3150","1218","action terminée via WP Cron","2025-03-31 09:22:28","2025-03-31 11:22:28"),
("3151","1219","action créée","2025-03-31 09:22:28","2025-03-31 11:22:28"),
("3152","1219","action commencée via Async Request","2025-04-01 09:22:41","2025-04-01 11:22:41"),
("3153","1219","action terminée via Async Request","2025-04-01 09:22:41","2025-04-01 11:22:41"),
("3154","1220","action créée","2025-04-01 09:22:41","2025-04-01 11:22:41"),
("3155","1220","action commencée via WP Cron","2025-04-02 09:27:28","2025-04-02 11:27:28"),
("3156","1220","action terminée via WP Cron","2025-04-02 09:27:28","2025-04-02 11:27:28"),
("3157","1221","action créée","2025-04-02 09:27:28","2025-04-02 11:27:28"),
("3501","1221","action commencée via WP Cron","2025-04-03 09:27:48","2025-04-03 11:27:48"),
("3502","1221","action terminée via WP Cron","2025-04-03 09:27:48","2025-04-03 11:27:48"),
("3503","1337","action créée","2025-04-03 09:27:48","2025-04-03 11:27:48"),
("6333","1337","action commencée via WP Cron","2025-04-04 09:29:44","2025-04-04 11:29:44"),
("6334","1337","action terminée via WP Cron","2025-04-04 09:29:44","2025-04-04 11:29:44"),
("6335","2281","action créée","2025-04-04 09:29:44","2025-04-04 11:29:44"),
("7868","2281","action commencée via WP Cron","2025-04-05 09:32:16","2025-04-05 11:32:16"),
("7869","2281","action terminée via WP Cron","2025-04-05 09:32:16","2025-04-05 11:32:16"),
("7870","2792","action créée","2025-04-05 09:32:16","2025-04-05 11:32:16"),
("9257","2792","action commencée via WP Cron","2025-04-06 09:57:54","2025-04-06 11:57:54"),
("9258","2792","action terminée via WP Cron","2025-04-06 09:57:54","2025-04-06 11:57:54"),
("9259","3255","action créée","2025-04-06 09:57:54","2025-04-06 11:57:54"),
("10493","3255","action commencée via WP Cron","2025-04-07 10:06:33","2025-04-07 12:06:33"),
("10494","3255","action terminée via WP Cron","2025-04-07 10:06:33","2025-04-07 12:06:33"),
("10495","3667","action créée","2025-04-07 10:06:33","2025-04-07 12:06:33"),
("12329","3667","action commencée via WP Cron","2025-04-08 10:07:15","2025-04-08 12:07:15"),
("12330","3667","action terminée via WP Cron","2025-04-08 10:07:15","2025-04-08 12:07:15"),
("12331","4269","action créée","2025-04-08 10:07:15","2025-04-08 12:07:15"),
("18400","4269","action commencée via WP Cron","2025-04-09 10:14:04","2025-04-09 12:14:04"),
("18401","4269","action terminée via WP Cron","2025-04-09 10:14:04","2025-04-09 12:14:04"),
("18402","6274","action créée","2025-04-09 10:14:04","2025-04-09 12:14:04"),
("23053","6274","action commencée via WP Cron","2025-04-10 10:14:08","2025-04-10 12:14:08"),
("23054","6274","action terminée via WP Cron","2025-04-10 10:14:08","2025-04-10 12:14:08"),
("23055","7825","action créée","2025-04-10 10:14:08","2025-04-10 12:14:08"),
("26362","7825","action commencée via WP Cron","2025-04-11 10:14:08","2025-04-11 12:14:08"),
("26363","7825","action terminée via WP Cron","2025-04-11 10:14:08","2025-04-11 12:14:08"),
("26364","8928","action créée","2025-04-11 10:14:08","2025-04-11 12:14:08"),
("29272","8928","action commencée via WP Cron","2025-04-12 10:16:50","2025-04-12 12:16:50"),
("29273","8928","action terminée via WP Cron","2025-04-12 10:16:50","2025-04-12 12:16:50"),
("29274","9898","action créée","2025-04-12 10:16:50","2025-04-12 12:16:50"),
("31900","9898","action commencée via WP Cron","2025-04-13 10:21:15","2025-04-13 12:21:15"),
("31901","9898","action terminée via WP Cron","2025-04-13 10:21:15","2025-04-13 12:21:15"),
("31902","10766","action créée","2025-04-13 10:21:15","2025-04-13 12:21:15"),
("34870","10766","action commencée via WP Cron","2025-04-14 10:24:22","2025-04-14 12:24:22"),
("34871","10766","action terminée via WP Cron","2025-04-14 10:24:22","2025-04-14 12:24:22"),
("34872","11756","action créée","2025-04-14 10:24:22","2025-04-14 12:24:22"),
("37744","11756","action commencée via WP Cron","2025-04-15 10:26:02","2025-04-15 12:26:02"),
("37745","11756","action terminée via WP Cron","2025-04-15 10:26:02","2025-04-15 12:26:02"),
("37746","12714","action créée","2025-04-15 10:26:02","2025-04-15 12:26:02"),
("40763","12714","action commencée via WP Cron","2025-04-16 10:54:25","2025-04-16 12:54:25"),
("40764","12714","action terminée via WP Cron","2025-04-16 10:54:25","2025-04-16 12:54:25"),
("40765","13729","action créée","2025-04-16 10:54:25","2025-04-16 12:54:25"),
("44598","13729","action commencée via WP Cron","2025-04-17 10:57:02","2025-04-17 12:57:02"),
("44599","13729","action terminée via WP Cron","2025-04-17 10:57:02","2025-04-17 12:57:02"),
("44600","15011","action créée","2025-04-17 10:57:02","2025-04-17 12:57:02"),
("47675","15011","action commencée via WP Cron","2025-04-18 10:57:30","2025-04-18 12:57:30"),
("47676","15011","action terminée via WP Cron","2025-04-18 10:57:30","2025-04-18 12:57:30"),
("47677","16018","action créée","2025-04-18 10:57:30","2025-04-18 12:57:30"),
("50438","16018","action commencée via WP Cron","2025-04-19 10:57:35","2025-04-19 12:57:35"),
("50439","16018","action terminée via WP Cron","2025-04-19 10:57:35","2025-04-19 12:57:35"),
("50440","16939","action créée","2025-04-19 10:57:36","2025-04-19 12:57:36"),
("53222","16939","action commencée via WP Cron","2025-04-20 10:58:06","2025-04-20 12:58:06"),
("53223","16939","action terminée via WP Cron","2025-04-20 10:58:06","2025-04-20 12:58:06"),
("53224","17864","action créée","2025-04-20 10:58:06","2025-04-20 12:58:06"),
("55981","17864","action commencée via WP Cron","2025-04-21 11:04:19","2025-04-21 13:04:19"),
("55982","17864","action terminée via WP Cron","2025-04-21 11:04:19","2025-04-21 13:04:19"),
("55983","18777","action créée","2025-04-21 11:04:19","2025-04-21 13:04:19"),
("58828","18777","action commencée via WP Cron","2025-04-22 11:05:40","2025-04-22 13:05:40"),
("58829","18777","action terminée via WP Cron","2025-04-22 11:05:40","2025-04-22 13:05:40"),
("58830","19726","action créée","2025-04-22 11:05:40","2025-04-22 13:05:40"),
("62031","19726","action commencée via WP Cron","2025-04-23 11:06:14","2025-04-23 13:06:14"),
("62032","19726","action terminée via WP Cron","2025-04-23 11:06:14","2025-04-23 13:06:14"),
("62033","20791","action créée","2025-04-23 11:06:14","2025-04-23 13:06:14"),
("65469","20791","action commencée via WP Cron","2025-04-24 11:42:45","2025-04-24 13:42:45"),
("65470","20791","action terminée via WP Cron","2025-04-24 11:42:45","2025-04-24 13:42:45"),
("65471","21951","action créée","2025-04-24 11:42:45","2025-04-24 13:42:45"),
("68786","21951","action commencée via WP Cron","2025-04-25 11:44:16","2025-04-25 13:44:16"),
("68787","21951","action terminée via WP Cron","2025-04-25 11:44:16","2025-04-25 13:44:16"),
("68788","23036","action créée","2025-04-25 11:44:16","2025-04-25 13:44:16"),
("72205","23036","action commencée via WP Cron","2025-04-26 12:08:35","2025-04-26 14:08:35"),
("72206","23036","action terminée via WP Cron","2025-04-26 12:08:35","2025-04-26 14:08:35"),
("72207","24185","action créée","2025-04-26 12:08:35","2025-04-26 14:08:35"),
("75201","24185","action commencée via WP Cron","2025-04-27 12:41:09","2025-04-27 14:41:09"),
("75202","24185","action terminée via WP Cron","2025-04-27 12:41:09","2025-04-27 14:41:09"),
("75203","25189","action créée","2025-04-27 12:41:09","2025-04-27 14:41:09"),
("77378","25900","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77379","25901","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77380","25902","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77381","25903","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77382","25904","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77383","25905","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77384","25906","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77385","25907","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77386","25908","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77387","25909","action créée","2025-04-28 05:10:55","2025-04-28 07:10:55"),
("77388","25910","action créée","2025-04-28 05:11:16","2025-04-28 07:11:16"),
("77389","25900","action commencée via WP Cron","2025-04-28 05:12:20","2025-04-28 07:12:20"),
("77390","25900","action terminée via WP Cron","2025-04-28 05:12:24","2025-04-28 07:12:24"),
("77391","25901","action commencée via WP Cron","2025-04-28 05:12:24","2025-04-28 07:12:24"),
("77392","25901","action terminée via WP Cron","2025-04-28 05:12:26","2025-04-28 07:12:26"),
("77393","25902","action commencée via WP Cron","2025-04-28 05:12:26","2025-04-28 07:12:26"),
("77394","25902","action terminée via WP Cron","2025-04-28 05:12:29","2025-04-28 07:12:29"),
("77395","25903","action commencée via WP Cron","2025-04-28 05:12:29","2025-04-28 07:12:29"),
("77396","25903","action terminée via WP Cron","2025-04-28 05:12:31","2025-04-28 07:12:31"),
("77397","25904","action commencée via WP Cron","2025-04-28 05:12:32","2025-04-28 07:12:32"),
("77398","25904","action terminée via WP Cron","2025-04-28 05:12:35","2025-04-28 07:12:35"),
("77399","25905","action commencée via WP Cron","2025-04-28 05:12:35","2025-04-28 07:12:35"),
("77400","25905","action terminée via WP Cron","2025-04-28 05:12:36","2025-04-28 07:12:36"),
("77401","25906","action commencée via WP Cron","2025-04-28 05:12:36","2025-04-28 07:12:36"),
("77402","25906","action terminée via WP Cron","2025-04-28 05:12:39","2025-04-28 07:12:39"),
("77403","25907","action commencée via WP Cron","2025-04-28 05:12:39","2025-04-28 07:12:39"),
("77404","25907","action terminée via WP Cron","2025-04-28 05:12:40","2025-04-28 07:12:40"),
("77405","25908","action commencée via WP Cron","2025-04-28 05:12:40","2025-04-28 07:12:40"),
("77406","25908","action terminée via WP Cron","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77407","25911","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77408","25912","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77409","25913","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77410","25914","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77411","25915","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77412","25916","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77413","25917","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77414","25918","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77415","25919","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77416","25920","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77417","25921","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77418","25922","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77419","25923","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77420","25924","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77421","25925","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77422","25926","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77423","25927","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77424","25928","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77425","25929","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77426","25930","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77427","25931","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77428","25932","action créée","2025-04-28 05:12:42","2025-04-28 07:12:42"),
("77429","25909","action commencée via WP Cron","2025-04-28 05:14:01","2025-04-28 07:14:01"),
("77430","25909","action terminée via WP Cron","2025-04-28 05:14:01","2025-04-28 07:14:01"),
("77431","25910","action commencée via WP Cron","2025-04-28 05:14:01","2025-04-28 07:14:01"),
("77432","25910","action terminée via WP Cron","2025-04-28 05:14:05","2025-04-28 07:14:05"),
("77433","25911","action commencée via WP Cron","2025-04-28 05:14:05","2025-04-28 07:14:05"),
("77434","25911","action terminée via WP Cron","2025-04-28 05:14:08","2025-04-28 07:14:08"),
("77435","25912","action commencée via WP Cron","2025-04-28 05:14:08","2025-04-28 07:14:08"),
("77436","25912","action terminée via WP Cron","2025-04-28 05:14:10","2025-04-28 07:14:10"),
("77437","25913","action commencée via WP Cron","2025-04-28 05:14:10","2025-04-28 07:14:10"),
("77438","25913","action terminée via WP Cron","2025-04-28 05:14:13","2025-04-28 07:14:13"),
("77439","25914","action commencée via WP Cron","2025-04-28 05:14:13","2025-04-28 07:14:13"),
("77440","25914","action terminée via WP Cron","2025-04-28 05:14:13","2025-04-28 07:14:13"),
("77441","25915","action commencée via WP Cron","2025-04-28 05:14:13","2025-04-28 07:14:13"),
("77442","25915","action terminée via WP Cron","2025-04-28 05:14:16","2025-04-28 07:14:16"),
("77443","25916","action commencée via WP Cron","2025-04-28 05:14:16","2025-04-28 07:14:16"),
("77444","25916","action terminée via WP Cron","2025-04-28 05:14:19","2025-04-28 07:14:19"),
("77445","25917","action commencée via WP Cron","2025-04-28 05:14:19","2025-04-28 07:14:19"),
("77446","25917","action terminée via WP Cron","2025-04-28 05:14:22","2025-04-28 07:14:22"),
("77447","25918","action commencée via WP Cron","2025-04-28 05:14:22","2025-04-28 07:14:22"),
("77448","25918","action terminée via WP Cron","2025-04-28 05:14:25","2025-04-28 07:14:25"),
("77449","25919","action commencée via WP Cron","2025-04-28 05:22:20","2025-04-28 07:22:20"),
("77450","25919","action terminée via WP Cron","2025-04-28 05:22:25","2025-04-28 07:22:25"),
("77451","25920","action commencée via WP Cron","2025-04-28 05:22:25","2025-04-28 07:22:25"),
("77452","25920","action terminée via WP Cron","2025-04-28 05:22:28","2025-04-28 07:22:28"),
("77453","25921","action commencée via WP Cron","2025-04-28 05:22:28","2025-04-28 07:22:28"),
("77454","25921","action terminée via WP Cron","2025-04-28 05:22:31","2025-04-28 07:22:31"),
("77455","25922","action commencée via WP Cron","2025-04-28 05:22:31","2025-04-28 07:22:31"),
("77456","25922","action terminée via WP Cron","2025-04-28 05:22:34","2025-04-28 07:22:34"),
("77457","25923","action commencée via WP Cron","2025-04-28 05:22:34","2025-04-28 07:22:34"),
("77458","25923","action terminée via WP Cron","2025-04-28 05:22:37","2025-04-28 07:22:37"),
("77459","25924","action commencée via WP Cron","2025-04-28 05:22:37","2025-04-28 07:22:37"),
("77460","25924","action terminée via WP Cron","2025-04-28 05:22:40","2025-04-28 07:22:40"),
("77461","25925","action commencée via WP Cron","2025-04-28 05:23:55","2025-04-28 07:23:55"),
("77462","25925","action terminée via WP Cron","2025-04-28 05:24:04","2025-04-28 07:24:04"),
("77463","25926","action commencée via WP Cron","2025-04-28 05:34:16","2025-04-28 07:34:16"),
("77464","25926","action terminée via WP Cron","2025-04-28 05:34:25","2025-04-28 07:34:25"),
("77465","25927","action commencée via WP Cron","2025-04-28 05:37:55","2025-04-28 07:37:55"),
("77466","25927","action terminée via WP Cron","2025-04-28 05:38:00","2025-04-28 07:38:00"),
("77467","25928","action commencée via WP Cron","2025-04-28 05:38:00","2025-04-28 07:38:00"),
("77468","25928","action terminée via WP Cron","2025-04-28 05:38:03","2025-04-28 07:38:03"),
("77469","25929","action commencée via WP Cron","2025-04-28 05:38:03","2025-04-28 07:38:03"),
("77470","25929","action terminée via WP Cron","2025-04-28 05:38:06","2025-04-28 07:38:06"),
("77471","25930","action commencée via WP Cron","2025-04-28 05:38:06","2025-04-28 07:38:06"),
("77472","25930","action terminée via WP Cron","2025-04-28 05:38:09","2025-04-28 07:38:09"),
("77473","25931","action commencée via WP Cron","2025-04-28 05:38:09","2025-04-28 07:38:09"),
("77474","25931","action terminée via WP Cron","2025-04-28 05:38:12","2025-04-28 07:38:12"),
("77475","25932","action commencée via WP Cron","2025-04-28 05:38:12","2025-04-28 07:38:12"),
("77476","25932","action terminée via WP Cron","2025-04-28 05:38:15","2025-04-28 07:38:15");

INSERT IGNORE INTO `wpeps_cmplz_cookiebanners` VALUES 
("1","Bannière A","19","1","bottom-left","slider","","0","1","Gérer le consentement","hover-hide-mobile","a:2:{s:4:\"text\";s:22:\"Gérer le consentement\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:7:\"Refuser\";s:4:\"show\";i:1;}","Enregistrer les préférences","Voir les préférences","Fonctionnel","a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:12:\"Statistiques\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:13:\"Préférences\";s:4:\"show\";i:1;}","Accepter","Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.","view-preferences","0","526","0","0","0","10","a:2:{s:4:\"text\";s:8:\"Accepter\";s:4:\"show\";i:1;}","Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.","0","/* Container */\n.cmplz-cookiebanner{}\n\n/* Logo */\n.cmplz-cookiebanner .cmplz-logo{}\n/* Title */\n.cmplz-cookiebanner .cmplz-title{}\n/* Close icon */\n.cmplz-cookiebanner .cmplz-close{}\n\n/* Message */\n.cmplz-cookiebanner .cmplz-message{}\n\n /* All buttons */\n.cmplz-buttons .cmplz-btn{}\n/* Accept button */\n.cmplz-btn .cmplz-accept{} \n /* Deny button */\n.cmplz-btn .cmplz-deny{}\n /* Save preferences button */\n.cmplz-btn .cmplz-deny{}\n /* View preferences button */\n.cmplz-btn .cmplz-deny{}\n\n /* Document hyperlinks */\n.cmplz-links .cmplz-documents{}\n\n /* Categories */\n.cmplz-cookiebanner .cmplz-category{}\n.cmplz-cookiebanner .cmplz-category-title{} \n\n/* Manage consent tab */\n#cmplz-manage-consent .cmplz-manage-consent{} \n\n/* Soft cookie wall */\n.cmplz-soft-cookiewall{}\n\n/* Placeholder button - Per category */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\n\n/* Placeholder button & message - Per service */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\n.cmplz-blocked-content-notice{}\nbutton.cmplz-accept-service{}\n\n/* Styles for the AMP notice */\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\n/* Message */\n#cmplz-consent-ui .cmplz-consent-message {}\n/* Buttons */\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}","a:0:{}","a:2:{s:4:\"text\";s:341:\"L’accès ou le stockage technique est strictement nécessaire dans la finalité d’intérêt légitime de permettre l’utilisation d’un service spécifique explicitement demandé par l’abonné ou l’utilisateur, ou dans le seul but d’effectuer la transmission d’une communication sur un réseau de communications électroniques.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:92:\"Le stockage ou l’accès technique qui est utilisé exclusivement à des fins statistiques.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:448:\"Le stockage ou l’accès technique qui est utilisé exclusivement dans des finalités statistiques anonymes. En l’absence d’une assignation à comparaître, d’une conformité volontaire de la part de votre fournisseur d’accès à internet ou d’enregistrements supplémentaires provenant d’une tierce partie, les informations stockées ou extraites à cette seule fin ne peuvent généralement pas être utilisées pour vous identifier.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:184:\"L’accès ou le stockage technique est nécessaire dans la finalité d’intérêt légitime de stocker des préférences qui ne sont pas demandées par l’abonné ou l’internaute.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:242:\"L’accès ou le stockage technique est nécessaire pour créer des profils d’internautes afin d’envoyer des publicités, ou pour suivre l’utilisateur sur un site web ou sur plusieurs sites web ayant des finalités marketing similaires.\";s:4:\"show\";i:1;}","a:2:{s:5:\"color\";s:7:\"#ffffff\";s:6:\"border\";s:7:\"#f2f2f2\";}","a:2:{s:5:\"color\";s:7:\"#222222\";s:9:\"hyperlink\";s:7:\"#122f4a\";}","a:3:{s:10:\"background\";s:7:\"#122f4a\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#F56E28\";}","a:5:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:4:\"type\";s:2:\"px\";}","a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}","12","a:3:{s:10:\"background\";s:7:\"#122f4a\";s:6:\"border\";s:7:\"#122f4a\";s:4:\"text\";s:7:\"#ffffff\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#222222\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#333333\";}","a:5:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:4:\"type\";s:2:\"px\";}","none","1","0","0","0","1");

INSERT IGNORE INTO `wpeps_cmplz_cookies` VALUES 
("1","_grecaptcha","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1745583206","1743670440"),
("2","_grecaptcha","","1","0","","","0","","","","fr","1","0","self","0","0","1","0","1745583206","1743670440"),
("3","wpEmojiSettingsSupports","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("4","wpEmojiSettingsSupports","","1","0","","","0","","","","fr","3","0","self","0","0","1","0","1745583207","1743670440"),
("5","wp-settings-1","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("6","wp-settings-1","","1","0","","","0","","","","fr","5","0","self","0","0","1","0","1745583207","1743670440"),
("7","wp-settings-time-1","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("8","wp-settings-time-1","","1","0","","","0","","","","fr","7","0","self","0","0","1","0","1745583207","1743670440"),
("9","cmplz_consented_services","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("10","cmplz_consented_services","","1","0","365 jours","","0","","","","fr","9","0","self","0","0","1","0","1745583207","1743670440"),
("11","cmplz_policy_id","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("12","cmplz_policy_id","","1","0","365 jours","","0","","","","fr","11","0","self","0","0","1","0","1745583207","1743670440"),
("13","cmplz_marketing","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("14","cmplz_marketing","","1","0","365 jours","","0","","","","fr","13","0","self","0","0","1","0","1745583207","1743670440"),
("15","cmplz_statistics","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("16","cmplz_statistics","","1","0","365 jours","","0","","","","fr","15","0","self","0","0","1","0","1745583207","1743670440"),
("17","cmplz_preferences","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("18","cmplz_preferences","","1","0","365 jours","","0","","","","fr","17","0","self","0","0","1","0","1745583207","1743670440"),
("19","cmplz_functional","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("20","cmplz_functional","","1","0","365 jours","","0","","","","fr","19","0","self","0","0","1","0","1745583207","1743670440"),
("21","cmplz_banner-status","","1","0","365 jours","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("22","cmplz_banner-status","","1","0","365 jours","","0","","","","fr","21","0","self","0","0","1","0","1745583207","1743670440"),
("23","wordpress_test_cookie","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("24","wordpress_test_cookie","","1","0","","","0","","","","fr","23","0","self","0","0","1","0","1745583207","1743670440"),
("25","wp-settings-2","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("26","wp-settings-2","","1","0","","","0","","","","fr","25","0","self","0","0","1","0","1745583207","1743670440"),
("27","wp-settings-time-2","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("28","wp-settings-time-2","","1","0","","","0","","","","fr","27","0","self","0","0","1","0","1745583207","1743670440"),
("29","sbjs_migrations","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("30","sbjs_migrations","","1","0","","","0","","","","fr","29","0","self","0","0","1","0","1745583207","1743670440"),
("31","sbjs_current_add","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("32","sbjs_current_add","","1","0","","","0","","","","fr","31","0","self","0","0","1","0","1745583207","1743670440"),
("33","sbjs_first_add","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("34","sbjs_first_add","","1","0","","","0","","","","fr","33","0","self","0","0","1","0","1745583207","1743670440"),
("35","sbjs_current","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("36","sbjs_current","","1","0","","","0","","","","fr","35","0","self","0","0","1","0","1745583207","1743670440"),
("37","sbjs_first","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("38","sbjs_first","","1","0","","","0","","","","fr","37","0","self","0","0","1","0","1745583207","1743670440"),
("39","sbjs_udata","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("40","sbjs_udata","","1","0","","","0","","","","fr","39","0","self","0","0","1","0","1745583207","1743670440"),
("41","_ga_SY5W4EQ0Y0","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("42","_ga_SY5W4EQ0Y0","","1","0","","","0","","","","fr","41","0","self","0","0","1","0","1745583207","1743670440"),
("43","_ga","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("44","_ga","","1","0","","","0","","","","fr","43","0","self","0","0","1","0","1745583207","1743670440"),
("45","_gid","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1743765468","1743670440"),
("46","_gid","","1","0","","","0","","","","fr","45","0","self","0","0","1","0","1743765468","1743670440"),
("47","sbjs_session","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("48","sbjs_session","","1","0","","","0","","","","fr","47","0","self","0","0","1","0","1745583207","1743670440"),
("49","wordpress_logged_in_3f7c2e1d96b49514b5a1e2a425ea5ada","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743670440"),
("50","wordpress_logged_in_3f7c2e1d96b49514b5a1e2a425ea5ada","","1","0","","","0","","","","fr","49","0","self","0","0","1","0","1745583207","1743670440"),
("51","_gat_gtag_UA_132352195_1","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1743765468","1743670443"),
("52","_gat_gtag_UA_132352195_1","","1","0","","","0","","","","fr","51","0","self","0","0","1","0","1743765468","1743670443"),
("53","persist:hs-beacon-message-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("54","persist:hs-beacon-message-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","","0","","","","fr","53","0","self","0","0","1","0","1744362557","1743672237"),
("55","wistia-video-progress-krqb7ckugp","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("56","wistia-video-progress-krqb7ckugp","","1","0","","","0","","","","fr","55","0","self","0","0","1","0","1744362557","1743672237"),
("57","wistia-video-progress-frwm2xrksl","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("58","wistia-video-progress-frwm2xrksl","","1","0","","","0","","","","fr","57","0","self","0","0","1","0","1744362557","1743672237"),
("59","persist:hs-beacon-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("60","persist:hs-beacon-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","","0","","","","fr","59","0","self","0","0","1","0","1744362557","1743672237"),
("61","wpr-show-sidebar","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("62","wpr-show-sidebar","","1","0","","","0","","","","fr","61","0","self","0","0","1","0","1744362557","1743672237"),
("63","wistia-video-progress-9m1zg8p5wc","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("64","wistia-video-progress-9m1zg8p5wc","","1","0","","","0","","","","fr","63","0","self","0","0","1","0","1744362557","1743672237"),
("65","wistia-video-progress-803tlui8oi","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("66","wistia-video-progress-803tlui8oi","","1","0","","","0","","","","fr","65","0","self","0","0","1","0","1744362557","1743672237"),
("67","wistia-video-progress-fj7gs031q6","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("68","wistia-video-progress-fj7gs031q6","","1","0","","","0","","","","fr","67","0","self","0","0","1","0","1744362557","1743672237"),
("69","wpr-hash","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("70","wpr-hash","","1","0","","","0","","","","fr","69","0","self","0","0","1","0","1744362557","1743672237"),
("71","wistia-video-progress-95z0cb0yxb","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("72","wistia-video-progress-95z0cb0yxb","","1","0","","","0","","","","fr","71","0","self","0","0","1","0","1744362557","1743672237"),
("73","wistia","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("74","wistia","","1","0","","","0","","","","fr","73","0","self","0","0","1","0","1744362557","1743672237"),
("75","wistia-video-progress-7seqacq2ol","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("76","wistia-video-progress-7seqacq2ol","","1","0","","","0","","","","fr","75","0","self","0","0","1","0","1744362557","1743672237"),
("77","WP_DATA_USER_2","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("78","WP_DATA_USER_2","","1","0","","","0","","","","fr","77","0","self","0","0","1","0","1744362557","1743672237"),
("79","wistia-video-progress-09kolaz9o0","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("80","wistia-video-progress-09kolaz9o0","","1","0","","","0","","","","fr","79","0","self","0","0","1","0","1744362557","1743672237"),
("81","wistia-video-progress-fj42vucf99","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("82","wistia-video-progress-fj42vucf99","","1","0","","","0","","","","fr","81","0","self","0","0","1","0","1744362557","1743672237"),
("83","wistia-video-progress-j042jylrre","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("84","wistia-video-progress-j042jylrre","","1","0","","","0","","","","fr","83","0","self","0","0","1","0","1744362557","1743672237"),
("85","wistia-video-progress-z1qxl7s2zn","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("86","wistia-video-progress-z1qxl7s2zn","","1","0","","","0","","","","fr","85","0","self","0","0","1","0","1744362557","1743672237"),
("87","wistia-video-progress-5wrdzcmj90","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1743672237"),
("88","wistia-video-progress-5wrdzcmj90","","1","0","","","0","","","","fr","87","0","self","0","0","1","0","1744362557","1743672237"),
("89","persist:hs-beacon-session-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1743672276","1743672237"),
("90","persist:hs-beacon-session-9db9417a-5e2f-41dd-8857-1421d5112aea","","1","0","","","0","","","","fr","89","0","self","0","0","1","0","1743672276","1743672237"),
("91","itsec-hb-login-3f7c2e1d96b49514b5a1e2a425ea5ada","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1743672237"),
("92","itsec-hb-login-3f7c2e1d96b49514b5a1e2a425ea5ada","","1","0","","","0","","","","fr","91","0","self","0","0","1","0","1745583207","1743672237"),
("93","wc_cart_hash_66300bb6f040f0c39785241c23c0f067","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1745583206","1743672275"),
("94","wc_cart_hash_66300bb6f040f0c39785241c23c0f067","","1","0","","","0","","","","fr","93","0","self","0","0","1","0","1745583206","1743672275"),
("95","wc_fragments_66300bb6f040f0c39785241c23c0f067","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1743672276","1743672276"),
("96","wc_fragments_66300bb6f040f0c39785241c23c0f067","","1","0","","","0","","","","fr","95","0","self","0","0","1","0","1743672276","1743672276"),
("97","Google Fonts API","","1","0","","","3","","","","en","0","0","thirdparty","0","0","1","0","1743765464","1743765464"),
("98","Google Fonts API","","1","0","","","4","","","","fr","97","0","thirdparty","0","0","1","0","1743765464","1743765464"),
("99","Google Maps API","","1","0","","","5","","","","en","0","0","thirdparty","0","0","1","0","1743765465","1743765465"),
("100","Google Maps API","","1","0","","","6","","","","fr","99","0","thirdparty","0","0","1","0","1743765465","1743765465"),
("101","storeApiNonce","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1744032262"),
("102","storeApiNonce","","1","0","","","0","","","","fr","101","0","self","0","0","1","0","1744362557","1744032262"),
("103","storeApiCartData","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1744362557","1744032262"),
("104","storeApiCartData","","1","0","","","0","","","","fr","103","0","self","0","0","1","0","1744362557","1744032262"),
("105","topicsLastReferenceTime","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1745583206","1745583206"),
("106","topicsLastReferenceTime","","1","0","","","0","","","","fr","105","0","self","0","0","1","0","1745583206","1745583206"),
("107","_fbp","","1","0","","cookie","0","","","","en","0","0","self","0","0","1","0","1745583207","1745583207"),
("108","_fbp","","1","0","","","0","","","","fr","107","0","self","0","0","1","0","1745583207","1745583207");

INSERT IGNORE INTO `wpeps_cmplz_services` VALUES 
("1","Google Analytics","google-analytics","website statistics","","1","1","1","https://business.safety.google/privacy/","en","0","1","1743765464"),
("2","Google Analytics","google-analytics","les statistiques du site web","","1","1","1","https://business.safety.google/privacy/","fr","1","1","1743765464"),
("3","Google Fonts","google-fonts","display of webfonts","utility","1","1","0","https://policies.google.com/privacy","en","0","1","1743765464"),
("4","Google Fonts","google-fonts","l’affichage des polices web","utility","1","1","0","https://policies.google.com/privacy","fr","3","1","1743765464"),
("5","Google Maps","google-maps","maps display","utility","1","1","0","https://business.safety.google/privacy/","en","0","1","1743765464"),
("6","Google Maps","google-maps","l’affichage de cartes","utility","1","1","0","https://business.safety.google/privacy/","fr","5","1","1743765464"),
("7","Instagram","instagram","display of recent social posts and/or social share buttons","social","1","1","1","https://privacycenter.instagram.com/policy/","en","0","1","1743765465"),
("8","Instagram","instagram","l’affichage de publications sociales récentes et/ou des boutons de partage de réseaux sociaux","social","1","1","1","https://privacycenter.instagram.com/policy/","fr","7","1","1743765465");

INSERT IGNORE INTO `wpeps_comments` VALUES 
("1","1","Un commentateur ou commentatrice WordPress","wapuu@wordpress.example","https://fr.wordpress.org/","","2024-12-02 16:01:22","2024-12-02 15:01:22","Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0"),
("2","1","Nigel63","Nigel63@gmail.com","","186.80.29.177","2025-04-15 20:44:51","2025-04-15 18:44:51","<a href=\"https://mazda-demio.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6337\" rel=\"nofollow ugc\">https://mazda-demio.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6337</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("3","1","Molly1292","Molly1292@gmail.com","","103.199.117.121","2025-04-23 06:01:38","2025-04-23 04:01:38","Awesome <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("4","1","Ronald972","Ronald972@gmail.com","","203.211.74.134","2025-04-24 00:29:11","2025-04-23 22:29:11","Very good <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("5","1","Frank2138","Frank2138@gmail.com","","49.151.76.119","2025-04-24 02:47:44","2025-04-24 00:47:44","Awesome <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("6","1","Ramona4491","Ramona4491@gmail.com","","49.76.184.82","2025-04-25 10:51:10","2025-04-25 08:51:10","Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("7","1","Margaret318","Margaret318@gmail.com","","83.110.122.11","2025-04-25 20:11:22","2025-04-25 18:11:22","Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("8","1","Deborah3965","Deborah3965@gmail.com","","114.10.29.45","2025-04-25 22:17:30","2025-04-25 20:17:30","Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("9","1","Colton2229","Colton2229@gmail.com","","121.227.145.220","2025-04-26 07:48:58","2025-04-26 05:48:58","Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("10","1","Katelyn4571","Katelyn4571@gmail.com","","195.90.200.68","2025-04-26 10:10:43","2025-04-26 08:10:43","Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("11","1","Jason1095","Jason1095@gmail.com","","148.103.142.182","2025-04-26 22:12:41","2025-04-26 20:12:41","Awesome <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("12","1","Marshall65","Marshall65@gmail.com","","181.23.116.27","2025-04-27 02:44:55","2025-04-27 00:44:55","Very good <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("13","1","Dorothy3778","Dorothy3778@gmail.com","","49.43.226.27","2025-04-27 19:37:07","2025-04-27 17:37:07","Awesome <a href=\"https://urlr.me/zH3wE5\" rel=\"nofollow ugc\">https://urlr.me/zH3wE5</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0"),
("14","1","Josephine2763","Josephine2763@gmail.com","","179.221.201.103","2025-04-28 00:03:46","2025-04-27 22:03:46","Awesome <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");

INSERT IGNORE INTO `wpeps_duplicator_backups` VALUES 
("4","20250403_elegancepiscinesspas","2a5d768bc4c8c5ec5502_20250403092805","20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_archive.zip","100","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250403_elegancepiscinesspas\",\n    \"Hash\": \"2a5d768bc4c8c5ec5502_20250403092805\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule Backup_monthly\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_scan.json\",\n    \"timer_start\": 1743672820.688228,\n    \"Runtime\": \"203.262 sec.\",\n    \"ExeSize\": \"128.67KB\",\n    \"ZipSize\": \"709.87MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 744350331,\n        \"Dirs\": [],\n        \"DirCount\": 3477,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 27686,\n        \"file_count\": 31162,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_installer.php\",\n        \"Size\": 131756,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"gdkR4c72Xmh\\/YeXYg79F\\/dmoNSwqJqHCGNlwlRpaaPbBjJH5+v8uHoNuMlZtlHtYkYEGyAQm70SriJzlkM4TXQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 85,\n            \"tablesFinalCount\": 85,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25640,\n            \"tablesSizeOnDisk\": 42418176,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"664\",\n                    \"insertedRows\": 780,\n                    \"size\": 491520\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1990\",\n                    \"insertedRows\": 2338,\n                    \"size\": 344064\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"92\",\n                    \"insertedRows\": 96,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 3,\n                    \"size\": 147456\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 19,\n                    \"size\": 163840\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 131072\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"87\",\n                    \"insertedRows\": 87,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"337\",\n                    \"insertedRows\": 337,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1772\",\n                    \"insertedRows\": 613,\n                    \"size\": 2555904\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"12797\",\n                    \"insertedRows\": 7513,\n                    \"size\": 8798208\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"2147\",\n                    \"insertedRows\": 786,\n                    \"size\": 25755648\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"67\",\n                    \"insertedRows\": 72,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 28,\n                    \"size\": 65536\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 18,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 5561293,\n        \"File\": \"20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250403_elegancepiscinesspas_2a5d768bc4c8c5ec5502_20250403092805_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 18,\n    \"descriptorsMng\": {\n        \"hash\": \"2a5d768-03092805\",\n        \"date\": \"20250403092805\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250403092805-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 14,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1743673024,\n            \"stopped_timestamp\": 1743673493,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 14,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:28:05\",\n    \"updated\": \"2025-04-03 09:44:53\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.20.1","2025-04-03 09:28:05","2025-04-03 09:44:53"),
("5","20250403_elegancepiscinesspas","18cfe72e7b8e49387961_20250403122326","20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_archive.zip","100","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 5,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250403_elegancepiscinesspas\",\n    \"Hash\": \"18cfe72e7b8e49387961_20250403122326\",\n    \"Type\": 2,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_semester\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_scan.json\",\n    \"timer_start\": 1743683058.058745,\n    \"Runtime\": \"684.926 sec.\",\n    \"ExeSize\": \"128.18KB\",\n    \"ZipSize\": \"729.01MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 764421326,\n        \"Dirs\": [],\n        \"DirCount\": 4651,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 31956,\n        \"file_count\": 36606,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_installer.php\",\n        \"Size\": 131252,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"FmGCYGW436NWbua5kjWqMgwtKHKbTRADJWDk564EDvIBR4\\/ARHHRYIJUnvONiUWHb6wVOLvOpcI5jWHoUCIN7w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 90,\n            \"tablesFinalCount\": 90,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25648,\n            \"tablesSizeOnDisk\": 42745856,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"664\",\n                    \"insertedRows\": 767,\n                    \"size\": 491520\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1990\",\n                    \"insertedRows\": 2260,\n                    \"size\": 344064\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"92\",\n                    \"insertedRows\": 96,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 4,\n                    \"size\": 147456\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 19,\n                    \"size\": 163840\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 21,\n                    \"size\": 131072\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"87\",\n                    \"insertedRows\": 87,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"337\",\n                    \"insertedRows\": 337,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1772\",\n                    \"insertedRows\": 778,\n                    \"size\": 2555904\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"12797\",\n                    \"insertedRows\": 7573,\n                    \"size\": 8798208\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"2147\",\n                    \"insertedRows\": 786,\n                    \"size\": 25755648\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"67\",\n                    \"insertedRows\": 72,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 15,\n                    \"size\": 81920\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 15,\n                    \"size\": 81920\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 62,\n                    \"size\": 65536\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 84,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6826847,\n        \"File\": \"20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250403_elegancepiscinesspas_18cfe72e7b8e49387961_20250403122326_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 19,\n    \"descriptorsMng\": {\n        \"hash\": \"18cfe72-03122326\",\n        \"date\": \"20250403122326\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250403122326-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 15,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 96.45003799856391,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1743683743,\n            \"stopped_timestamp\": 1743684239,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 15,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-03 12:23:26\",\n    \"updated\": \"2025-04-03 12:43:59\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-03 12:23:26","2025-04-03 12:43:59"),
("15","20250408_elegancepiscinesspas","11db964a59e0f2d17295_20250408060441","20250408_elegancepiscinesspas_11db964a59e0f2d17295_20250408060441_archive.zip","-2","-2","SCHEDULE,ZIP_ARCHIVE","{\n    \"ID\": 15,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250408_elegancepiscinesspas\",\n    \"Hash\": \"11db964a59e0f2d17295_20250408060441\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250408_elegancepiscinesspas_11db964a59e0f2d17295_20250408060441_scan.json\",\n    \"timer_start\": 1744092302.314804,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 1045240419,\n        \"Dirs\": [],\n        \"DirCount\": 4987,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33719,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"tZnG42MHcoVSq35xAy7l+Unz\\/TzmXZK31PmRkJ\\/1NB0THb5lbvGFsQ7dDIxtfv\\/\\/KaLdX4WudZsWQ2f3ULPTGQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 17975,\n            \"tablesSizeOnDisk\": 41254912,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"299\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"895\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 1327104\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"102\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1065\",\n                    \"insertedRows\": 0,\n                    \"size\": 4554752\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"6405\",\n                    \"insertedRows\": 0,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"707\",\n                    \"insertedRows\": 0,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"106\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"77\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 0,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 0,\n                    \"size\": 1687552\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"322\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"183\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"370\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"476\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHP\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": true,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-08 06:04:41\",\n    \"updated\": \"2025-04-08 06:30:14\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-08 06:04:41","2025-04-08 06:30:14"),
("17","20250409_elegancepiscinesspas","64a9337aa2fef27d5734_20250409061248","20250409_elegancepiscinesspas_64a9337aa2fef27d5734_20250409061248_archive.zip","-2","-2","SCHEDULE,ZIP_ARCHIVE","{\n    \"ID\": 17,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250409_elegancepiscinesspas\",\n    \"Hash\": \"64a9337aa2fef27d5734_20250409061248\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250409_elegancepiscinesspas_64a9337aa2fef27d5734_20250409061248_scan.json\",\n    \"timer_start\": 1744179189.796983,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 1045240419,\n        \"Dirs\": [],\n        \"DirCount\": 4987,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33719,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"q0qfO+g5zBpgx6tOkBK3UUDB\\/\\/pZ2Aln8EZ37XkIFX0VeiD1JnoTajVp+hqLP0nvH59Fx7GzgxlS0MmZiIx4ow==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 23764,\n            \"tablesSizeOnDisk\": 45154304,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"389\",\n                    \"insertedRows\": 0,\n                    \"size\": 327680\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1165\",\n                    \"insertedRows\": 0,\n                    \"size\": 229376\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 0,\n                    \"size\": 1327104\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"118\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1160\",\n                    \"insertedRows\": 0,\n                    \"size\": 5603328\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"9852\",\n                    \"insertedRows\": 0,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"746\",\n                    \"insertedRows\": 0,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"106\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"77\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 0,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"730\",\n                    \"insertedRows\": 0,\n                    \"size\": 3883008\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"863\",\n                    \"insertedRows\": 0,\n                    \"size\": 327680\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"457\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"917\",\n                    \"insertedRows\": 0,\n                    \"size\": 573440\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHP\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": true,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-09 06:12:48\",\n    \"updated\": \"2025-04-09 06:23:22\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-09 06:12:48","2025-04-09 06:23:22"),
("29","20250415_elegancepiscinesspas","c3e7b73b3823095c2478_20250415060027","20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_archive.zip","-2","-2","SCHEDULE,ZIP_ARCHIVE","{\n    \"ID\": 29,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250415_elegancepiscinesspas\",\n    \"Hash\": \"c3e7b73b3823095c2478_20250415060027\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_scan.json\",\n    \"timer_start\": 1744697139.151749,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 1045062562,\n        \"Dirs\": [],\n        \"DirCount\": 4987,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33717,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"CdDCV8rGCI26zqSn3vTCXdqEkMoBNbLjmqu7M0GeEjYOhv09\\/wzs6of0RK+JgUQUNXOfzKHfZfU7k3hcULwo8Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22198,\n            \"tablesSizeOnDisk\": 46219264,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"170\",\n                    \"insertedRows\": 200,\n                    \"size\": 212992\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"508\",\n                    \"insertedRows\": 585,\n                    \"size\": 114688\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 16,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"198\",\n                    \"insertedRows\": 198,\n                    \"size\": 294912\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1225\",\n                    \"insertedRows\": 1400,\n                    \"size\": 5619712\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"8755\",\n                    \"insertedRows\": 7788,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"751\",\n                    \"insertedRows\": 790,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"106\",\n                    \"insertedRows\": 106,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"77\",\n                    \"insertedRows\": 77,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"819\",\n                    \"insertedRows\": 960,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"954\",\n                    \"insertedRows\": 960,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"999\",\n                    \"insertedRows\": 1005,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13653764,\n        \"File\": \"20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250415_elegancepiscinesspas_c3e7b73b3823095c2478_20250415060027_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": true,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-15 06:00:27\",\n    \"updated\": \"2025-04-15 07:54:50\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-15 06:00:27","2025-04-15 07:54:50");

INSERT IGNORE INTO `wpeps_duplicator_backups` VALUES 
("40","20250421_elegancepiscinesspas","016b35705b4b6dca3766_20250421000010","20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 40,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250421_elegancepiscinesspas\",\n    \"Hash\": \"016b35705b4b6dca3766_20250421000010\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_scan.json\",\n    \"timer_start\": 1745193619.794868,\n    \"Runtime\": \"28.852 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.4MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3565241,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"RTTfje5AGrZQzztIghOl411kCl+3FOEeoWlH3lcM3S9a+JJB+NlpBJhfgrq5Sg2OALPyACwcIDJEpbzaJwFq7A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20663,\n            \"tablesSizeOnDisk\": 46219264,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"151\",\n                    \"insertedRows\": 100,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"451\",\n                    \"insertedRows\": 298,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"274\",\n                    \"insertedRows\": 287,\n                    \"size\": 344064\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1110\",\n                    \"insertedRows\": 1068,\n                    \"size\": 5619712\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"7276\",\n                    \"insertedRows\": 7823,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"751\",\n                    \"insertedRows\": 794,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"829\",\n                    \"insertedRows\": 978,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"977\",\n                    \"insertedRows\": 978,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1017\",\n                    \"insertedRows\": 1018,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 12982374,\n        \"File\": \"20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250421_elegancepiscinesspas_016b35705b4b6dca3766_20250421000010_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"016b357-21000010\",\n        \"date\": \"20250421000010\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250421000010-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745193649,\n            \"stopped_timestamp\": 1745193651,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-21 00:00:10\",\n    \"updated\": \"2025-04-21 00:00:51\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-21 00:00:10","2025-04-21 00:00:51"),
("42","20250422_elegancepiscinesspas","f2fdb2f57084a30b9343_20250422000012","20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 42,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250422_elegancepiscinesspas\",\n    \"Hash\": \"f2fdb2f57084a30b9343_20250422000012\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_scan.json\",\n    \"timer_start\": 1745280020.254919,\n    \"Runtime\": \"23.935 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.41MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3575685,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"6Te2HLid\\/C\\/ZI0UbGsnJm1PlWfGGdGOGKxCdbf89XANn6gcdo3DfHECQUp2AHV6bG3DEFHGf55tp2Ki6mYh\\/jg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 17777,\n            \"tablesSizeOnDisk\": 46202880,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"105\",\n                    \"insertedRows\": 126,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"313\",\n                    \"insertedRows\": 376,\n                    \"size\": 81920\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 300,\n                    \"size\": 360448\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1121\",\n                    \"insertedRows\": 1075,\n                    \"size\": 5603328\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"4411\",\n                    \"insertedRows\": 7823,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"755\",\n                    \"insertedRows\": 794,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"961\",\n                    \"insertedRows\": 979,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"978\",\n                    \"insertedRows\": 979,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1018\",\n                    \"insertedRows\": 1019,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13473733,\n        \"File\": \"20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250422_elegancepiscinesspas_f2fdb2f57084a30b9343_20250422000012_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"f2fdb2f-22000012\",\n        \"date\": \"20250422000012\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250422000012-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745280045,\n            \"stopped_timestamp\": 1745280048,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-22 00:00:12\",\n    \"updated\": \"2025-04-22 00:00:48\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-22 00:00:12","2025-04-22 00:00:48"),
("44","20250423_elegancepiscinesspas","ace8e05838df87154192_20250423000020","20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 44,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250423_elegancepiscinesspas\",\n    \"Hash\": \"ace8e05838df87154192_20250423000020\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_scan.json\",\n    \"timer_start\": 1745366426.28094,\n    \"Runtime\": \"16.413 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.44MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3605732,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"LMQz4jyHNZMhSd7rndtNpmnq2+8NI6M0sXF2K3YY0BVIWGRYfz\\/lrRv9Z61MtkZLn4CIIKSPPt0I5WiGzkB5dQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21955,\n            \"tablesSizeOnDisk\": 45154304,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"146\",\n                    \"insertedRows\": 183,\n                    \"size\": 180224\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"410\",\n                    \"insertedRows\": 504,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"300\",\n                    \"insertedRows\": 313,\n                    \"size\": 360448\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1084\",\n                    \"insertedRows\": 1201,\n                    \"size\": 4554752\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"8567\",\n                    \"insertedRows\": 7823,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"677\",\n                    \"insertedRows\": 794,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"945\",\n                    \"insertedRows\": 981,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"979\",\n                    \"insertedRows\": 981,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"449\",\n                    \"insertedRows\": 449,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1019\",\n                    \"insertedRows\": 1019,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14160002,\n        \"File\": \"20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250423_elegancepiscinesspas_ace8e05838df87154192_20250423000020_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"ace8e05-23000020\",\n        \"date\": \"20250423000020\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250423000020-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745366443,\n            \"stopped_timestamp\": 1745366445,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-23 00:00:20\",\n    \"updated\": \"2025-04-23 00:00:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-23 00:00:20","2025-04-23 00:00:45"),
("46","20250424_elegancepiscinesspas","6257d3587f4d14b58128_20250424000359","20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 46,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250424_elegancepiscinesspas\",\n    \"Hash\": \"6257d3587f4d14b58128_20250424000359\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_scan.json\",\n    \"timer_start\": 1745453044.292478,\n    \"Runtime\": \"45.273 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.44MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3608045,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"IbadNl961QhKzhADfWKvbPURN1Uxs9gK8yNsgReu5JeMZjqAp2te7h4WdirrXA+ewuZcsNJPsK4PI9hm2N4spw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 18202,\n            \"tablesSizeOnDisk\": 46268416,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"234\",\n                    \"insertedRows\": 170,\n                    \"size\": 229376\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"616\",\n                    \"insertedRows\": 508,\n                    \"size\": 114688\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 4,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"313\",\n                    \"insertedRows\": 335,\n                    \"size\": 360448\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1206\",\n                    \"insertedRows\": 1204,\n                    \"size\": 5603328\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"4403\",\n                    \"insertedRows\": 7830,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"733\",\n                    \"insertedRows\": 795,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"868\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"981\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"449\",\n                    \"insertedRows\": 449,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1019\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13738039,\n        \"File\": \"20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250424_elegancepiscinesspas_6257d3587f4d14b58128_20250424000359_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"6257d35-24000359\",\n        \"date\": \"20250424000359\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250424000359-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745453090,\n            \"stopped_timestamp\": 1745453092,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-24 00:03:59\",\n    \"updated\": \"2025-04-24 00:04:52\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-24 00:03:59","2025-04-24 00:04:52");

INSERT IGNORE INTO `wpeps_duplicator_backups` VALUES 
("48","20250425_elegancepiscinesspas","b9983375b4758c039867_20250425000015","20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 48,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250425_elegancepiscinesspas\",\n    \"Hash\": \"b9983375b4758c039867_20250425000015\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_scan.json\",\n    \"timer_start\": 1745539228.497558,\n    \"Runtime\": \"17.980 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.42MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3589374,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"zvF5wgAQKDVI3TUdDF\\/LZqg0qK8KloAqf58LO6PiOKw\\/eqS0nlgzjphhD1Olbu8ci6sgEmBypvWDsV4EVnNDgQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21658,\n            \"tablesSizeOnDisk\": 46252032,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"135\",\n                    \"insertedRows\": 230,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 12,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"403\",\n                    \"insertedRows\": 639,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 5,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"335\",\n                    \"insertedRows\": 349,\n                    \"size\": 376832\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1267\",\n                    \"insertedRows\": 1235,\n                    \"size\": 5619712\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"8045\",\n                    \"insertedRows\": 7830,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"778\",\n                    \"insertedRows\": 795,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"860\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13416799,\n        \"File\": \"20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250425_elegancepiscinesspas_b9983375b4758c039867_20250425000015_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"b998337-25000015\",\n        \"date\": \"20250425000015\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250425000015-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745539247,\n            \"stopped_timestamp\": 1745539249,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-25 00:00:15\",\n    \"updated\": \"2025-04-25 00:00:49\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-25 00:00:15","2025-04-25 00:00:49"),
("49","20250425_elegancepiscinesspas","04ca4559d032ff863012_20250425060044","20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_archive.zip","100","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","{\n    \"ID\": 49,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250425_elegancepiscinesspas\",\n    \"Hash\": \"04ca4559d032ff863012_20250425060044\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_scan.json\",\n    \"timer_start\": 1745561177.382072,\n    \"Runtime\": \"1735.503 sec.\",\n    \"ExeSize\": \"128.18KB\",\n    \"ZipSize\": \"732.47MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 768046777,\n        \"Dirs\": [],\n        \"DirCount\": 4989,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33719,\n        \"file_count\": 38707,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_installer.php\",\n        \"Size\": 131252,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"0v0fL0xu1tmE+1atEnp47FlqKnJtUrcBVR6njSxheRZRvFXIbg7ABmYjNzGntHlzfCy6OIJO4E\\/gu1YZ4JwPOg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 19178,\n            \"tablesSizeOnDisk\": 45268992,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"215\",\n                    \"insertedRows\": 96,\n                    \"size\": 212992\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"643\",\n                    \"insertedRows\": 286,\n                    \"size\": 114688\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 104,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"349\",\n                    \"insertedRows\": 349,\n                    \"size\": 393216\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1242\",\n                    \"insertedRows\": 1414,\n                    \"size\": 4587520\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"5266\",\n                    \"insertedRows\": 7830,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"752\",\n                    \"insertedRows\": 795,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2415,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"875\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 449,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 477,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13142255,\n        \"File\": \"20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250425_elegancepiscinesspas_04ca4559d032ff863012_20250425060044_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": {\n        \"hash\": \"04ca455-25060044\",\n        \"date\": \"20250425060044\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250425060044-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745562913,\n            \"stopped_timestamp\": 1745562953,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 13,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-25 06:00:44\",\n    \"updated\": \"2025-04-25 06:35:53\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-25 06:00:44","2025-04-25 06:35:53"),
("50","20250426_elegancepiscinesspas","dd2d6babfff45e9e3743_20250426000032","20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 50,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250426_elegancepiscinesspas\",\n    \"Hash\": \"dd2d6babfff45e9e3743_20250426000032\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_scan.json\",\n    \"timer_start\": 1745625655.217475,\n    \"Runtime\": \"74.911 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.62MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3799272,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"uVtTlXwTMel2zEb+y9Yr4UtdnN6w5MD138EdZvSQz54H\\/pZ1KgCJqrz72QhDM5Xr2K2r0Mx7Vvc2yqP4r7asAg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 19178,\n            \"tablesSizeOnDisk\": 45268992,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"215\",\n                    \"insertedRows\": 170,\n                    \"size\": 212992\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"643\",\n                    \"insertedRows\": 508,\n                    \"size\": 114688\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 108,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 8,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"349\",\n                    \"insertedRows\": 372,\n                    \"size\": 393216\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1242\",\n                    \"insertedRows\": 1344,\n                    \"size\": 4587520\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"5266\",\n                    \"insertedRows\": 7843,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"752\",\n                    \"insertedRows\": 800,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2415\",\n                    \"insertedRows\": 2416,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"875\",\n                    \"insertedRows\": 983,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 983,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"477\",\n                    \"insertedRows\": 479,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 79,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14750283,\n        \"File\": \"20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250426_elegancepiscinesspas_dd2d6babfff45e9e3743_20250426000032_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"dd2d6ba-26000032\",\n        \"date\": \"20250426000032\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250426000032-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745625741,\n            \"stopped_timestamp\": 1745625745,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-26 00:00:32\",\n    \"updated\": \"2025-04-26 00:02:25\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-26 00:00:32","2025-04-26 00:02:25"),
("51","20250426_elegancepiscinesspas","837787ee4cf0c2e26966_20250426060045","20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_archive.zip","100","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","{\n    \"ID\": 51,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250426_elegancepiscinesspas\",\n    \"Hash\": \"837787ee4cf0c2e26966_20250426060045\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_scan.json\",\n    \"timer_start\": 1745647457.414235,\n    \"Runtime\": \"1803.115 sec.\",\n    \"ExeSize\": \"128.18KB\",\n    \"ZipSize\": \"732.9MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 768505119,\n        \"Dirs\": [],\n        \"DirCount\": 4989,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33737,\n        \"file_count\": 38725,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_installer.php\",\n        \"Size\": 131252,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"+QGs9FcCFYrcHlKtvME\\/moc6E89gxSswI1r1q+ROhLDbPohILAK8PGAMfwIZchkXcrKsMZPOQGK92KzuGq2WbQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20381,\n            \"tablesSizeOnDisk\": 47366144,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"161\",\n                    \"insertedRows\": 94,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"434\",\n                    \"insertedRows\": 280,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 9,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"372\",\n                    \"insertedRows\": 373,\n                    \"size\": 409600\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1321\",\n                    \"insertedRows\": 1480,\n                    \"size\": 6684672\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"6660\",\n                    \"insertedRows\": 7843,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"683\",\n                    \"insertedRows\": 800,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2416\",\n                    \"insertedRows\": 2416,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"858\",\n                    \"insertedRows\": 983,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"983\",\n                    \"insertedRows\": 983,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 449,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"479\",\n                    \"insertedRows\": 479,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14155597,\n        \"File\": \"20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250426_elegancepiscinesspas_837787ee4cf0c2e26966_20250426060045_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": {\n        \"hash\": \"837787e-26060045\",\n        \"date\": \"20250426060045\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250426060045-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745649261,\n            \"stopped_timestamp\": 1745649316,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 13,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-26 06:00:45\",\n    \"updated\": \"2025-04-26 06:35:16\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-26 06:00:45","2025-04-26 06:35:16"),
("52","20250427_elegancepiscinesspas","4b1c4773632854056546_20250427000456","20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 52,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250427_elegancepiscinesspas\",\n    \"Hash\": \"4b1c4773632854056546_20250427000456\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_scan.json\",\n    \"timer_start\": 1745712334.370839,\n    \"Runtime\": \"86.813 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.45MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3618410,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"\\/BCknyXk3aT5QPvvQQARJb1ROpLzVdvL8v\\/97kPcnkBPN7H9rmzuobpeMZLfgTlxFE9lWyBDymKOcUCwmj6h7Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20381,\n            \"tablesSizeOnDisk\": 47366144,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"161\",\n                    \"insertedRows\": 118,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"434\",\n                    \"insertedRows\": 282,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 11,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"372\",\n                    \"insertedRows\": 397,\n                    \"size\": 409600\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1321\",\n                    \"insertedRows\": 1066,\n                    \"size\": 6684672\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"6660\",\n                    \"insertedRows\": 7850,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"683\",\n                    \"insertedRows\": 801,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2416\",\n                    \"insertedRows\": 2416,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"858\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"983\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"479\",\n                    \"insertedRows\": 479,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14437969,\n        \"File\": \"20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250427_elegancepiscinesspas_4b1c4773632854056546_20250427000456_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"4b1c477-27000456\",\n        \"date\": \"20250427000456\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250427000456-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745712429,\n            \"stopped_timestamp\": 1745712439,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-27 00:04:56\",\n    \"updated\": \"2025-04-27 00:07:19\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-27 00:04:56","2025-04-27 00:07:19");

INSERT IGNORE INTO `wpeps_duplicator_backups` VALUES 
("53","20250427_elegancepiscinesspas","ceea3b159ce0c9fb9879_20250427060437","20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_archive.zip","100","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","{\n    \"ID\": 53,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250427_elegancepiscinesspas\",\n    \"Hash\": \"ceea3b159ce0c9fb9879_20250427060437\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_scan.json\",\n    \"timer_start\": 1745734173.136064,\n    \"Runtime\": \"1592.625 sec.\",\n    \"ExeSize\": \"128.18KB\",\n    \"ZipSize\": \"732.73MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 768324390,\n        \"Dirs\": [],\n        \"DirCount\": 4989,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33737,\n        \"file_count\": 38725,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_installer.php\",\n        \"Size\": 131252,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"VZxAezCaV2gSC91ZGXIvPlD4RNjd66VpowMfTRb6o62X\\/eMez9erMKB3PZjIUcln5XovGRbSzFazkdL\\/EMK\\/0g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 24817,\n            \"tablesSizeOnDisk\": 46284800,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"151\",\n                    \"insertedRows\": 67,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"395\",\n                    \"insertedRows\": 199,\n                    \"size\": 81920\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"397\",\n                    \"insertedRows\": 397,\n                    \"size\": 425984\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1085\",\n                    \"insertedRows\": 1173,\n                    \"size\": 5603328\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"11362\",\n                    \"insertedRows\": 7857,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"751\",\n                    \"insertedRows\": 802,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2416\",\n                    \"insertedRows\": 2416,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"782\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"479\",\n                    \"insertedRows\": 479,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13197317,\n        \"File\": \"20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250427_elegancepiscinesspas_ceea3b159ce0c9fb9879_20250427060437_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": {\n        \"hash\": \"ceea3b1-27060437\",\n        \"date\": \"20250427060437\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250427060437-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745735766,\n            \"stopped_timestamp\": 1745735812,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 13,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-27 06:04:37\",\n    \"updated\": \"2025-04-27 06:36:53\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-27 06:04:37","2025-04-27 06:36:53"),
("54","20250428_elegancepiscinesspas","cf53d3b1f24772511791_20250428000110","20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_archive.zip","100","100","SCHEDULE,DB_ONLY,HAVE_LOCAL,ZIP_ARCHIVE","{\n    \"ID\": 54,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250428_elegancepiscinesspas\",\n    \"Hash\": \"cf53d3b1f24772511791_20250428000110\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_bdd\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_scan.json\",\n    \"timer_start\": 1745798484.669773,\n    \"Runtime\": \"20.210 sec.\",\n    \"ExeSize\": \"128.17KB\",\n    \"ZipSize\": \"3.45MB\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www\\/wp-admin\",\n            \"\\/home\\/elegancebq\\/www\\/wp-includes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/et-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wp-rocket-config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \"error_log\",\n            \"debug_log\",\n            \"ws_ftp.log\",\n            \"dbcache\",\n            \"pgcache\",\n            \"objectcache\",\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-login.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-signup.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-cron.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/elegancebq\\/www\\/readme.html\",\n            \"\\/home\\/elegancebq\\/www\\/wp-settings.php\",\n            \"\\/home\\/elegancebq\\/www\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-trackback.php\",\n            \"\\/home\\/elegancebq\\/www\\/xmlrpc.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-load.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-activate.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-mail.php\",\n            \"\\/home\\/elegancebq\\/www\\/license.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/advanced-cache.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/temp-write-test-67c81429c91826-69019642\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/20250401_elegancepiscinesspas_c9418bd406de99484328_20250401131958_log.txt\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 3620279,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 0,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_installer.php\",\n        \"Size\": 131243,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"OjiMV5pEnO5B4qtNNDp14LG\\/7wS5Nf2Pa3WILXQyRWQDHjSVLa2oKeRkTCLAcWoHuKkhjtYW4thp4R5XYKDGgA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 24817,\n            \"tablesSizeOnDisk\": 46284800,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"151\",\n                    \"insertedRows\": 62,\n                    \"size\": 196608\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 12,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"395\",\n                    \"insertedRows\": 168,\n                    \"size\": 81920\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 14,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"397\",\n                    \"insertedRows\": 419,\n                    \"size\": 425984\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 113,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 381,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 116,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1085\",\n                    \"insertedRows\": 1087,\n                    \"size\": 5603328\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"11362\",\n                    \"insertedRows\": 7857,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"751\",\n                    \"insertedRows\": 802,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2416\",\n                    \"insertedRows\": 2416,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 388,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 375,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 108,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 1584,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 119,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"782\",\n                    \"insertedRows\": 982,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 982,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 450,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 1020,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 481,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"479\",\n                    \"insertedRows\": 479,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 79,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14160082,\n        \"File\": \"20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250428_elegancepiscinesspas_cf53d3b1f24772511791_20250428000110_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 16,\n    \"descriptorsMng\": {\n        \"hash\": \"cf53d3b-28000110\",\n        \"date\": \"20250428000110\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250428000110-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 12,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1745798507,\n            \"stopped_timestamp\": 1745798510,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 12,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-28 00:01:10\",\n    \"updated\": \"2025-04-28 00:01:50\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-28 00:01:10","2025-04-28 00:01:50"),
("55","20250428_elegancepiscinesspas","da2217f92f4c36e91651_20250428060359","20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_archive.zip","20","20","SCHEDULE,ZIP_ARCHIVE","{\n    \"ID\": 55,\n    \"VersionWP\": \"6.8\",\n    \"VersionDB\": \"8.0.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250428_elegancepiscinesspas\",\n    \"Hash\": \"da2217f92f4c36e91651_20250428060359\",\n    \"Type\": 1,\n    \"notes\": \"Cr\\u00e9\\u00e9 par la planification Backup_all\",\n    \"StorePath\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_scan.json\",\n    \"timer_start\": 1745820586.466585,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Par d\\u00e9faut\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/all\",\n            \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n            \"\\/home\\/elegancebq\\/www\\/.opcache\",\n            \"\\/home\\/elegancebq\\/www\\/.tmb\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/elegancebq\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n            \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n            \"\\/home\\/elegancebq\\/www\\/php.ini\",\n            \"\\/home\\/elegancebq\\/www\\/web.config\",\n            \"\\/home\\/elegancebq\\/www\\/wp-config.php\",\n            \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/elegancebq\\/www\",\n        \"Size\": 1045945621,\n        \"Dirs\": [],\n        \"DirCount\": 4989,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 33737,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 232494028,\n                        \"bytes\": \"221.72MB\",\n                        \"nodes\": 25206,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 425924826,\n                        \"bytes\": \"406.19MB\",\n                        \"nodes\": 4271,\n                        \"name\": \"01\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/01\"\n                    },\n                    {\n                        \"ubytes\": 171633030,\n                        \"bytes\": \"163.68MB\",\n                        \"nodes\": 2158,\n                        \"name\": \"03\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/03\"\n                    },\n                    {\n                        \"ubytes\": 598475664,\n                        \"bytes\": \"570.75MB\",\n                        \"nodes\": 6465,\n                        \"name\": \"2025\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2025\"\n                    },\n                    {\n                        \"ubytes\": 645781681,\n                        \"bytes\": \"615.87MB\",\n                        \"nodes\": 7842,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 985583641,\n                        \"bytes\": \"939.93MB\",\n                        \"nodes\": 35638,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [\n                    \"\\/home\\/elegancebq\\/www-backups-2025\\/bdd\",\n                    \"\\/home\\/elegancebq\\/www-backups-2025\\/all\"\n                ],\n                \"Global\": [\n                    \"\\/home\\/elegancebq\\/www\\/wp-snapshots\",\n                    \"\\/home\\/elegancebq\\/www\\/.opcache\",\n                    \"\\/home\\/elegancebq\\/www\\/.tmb\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/old-cache\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/updraft\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/wfcache\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/cache\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 7601808,\n                        \"bytes\": \"7.25MB\",\n                        \"nodes\": 1,\n                        \"name\": \"modules-page-17456413848788.data\",\n                        \"dir\": \"wp-content\\/et-cache\\/fr_FR\",\n                        \"path\": \"wp-content\\/et-cache\\/fr_FR\\/modules-page-17456413848788.data\"\n                    },\n                    {\n                        \"ubytes\": 7601808,\n                        \"bytes\": \"7.25MB\",\n                        \"nodes\": 1,\n                        \"name\": \"modules-post-17456412851857.data\",\n                        \"dir\": \"wp-content\\/et-cache\\/fr_FR\",\n                        \"path\": \"wp-content\\/et-cache\\/fr_FR\\/modules-post-17456412851857.data\"\n                    },\n                    {\n                        \"ubytes\": 7602149,\n                        \"bytes\": \"7.25MB\",\n                        \"nodes\": 1,\n                        \"name\": \"modules-product-17456405984523.data\",\n                        \"dir\": \"wp-content\\/et-cache\\/fr_FR\",\n                        \"path\": \"wp-content\\/et-cache\\/fr_FR\\/modules-product-17456405984523.data\"\n                    },\n                    {\n                        \"ubytes\": 4931118,\n                        \"bytes\": \"4.7MB\",\n                        \"nodes\": 1,\n                        \"name\": \"sass.dart.js\",\n                        \"dir\": \"wp-content\\/plugins\\/ninja-forms-style\\/layouts\\/node_modules\\/sass\",\n                        \"path\": \"wp-content\\/plugins\\/ninja-forms-style\\/layouts\\/node_modules\\/sass\\/sass.dart.js\"\n                    },\n                    {\n                        \"ubytes\": 4206650,\n                        \"bytes\": \"4.01MB\",\n                        \"nodes\": 1,\n                        \"name\": \"bundle.js\",\n                        \"dir\": \"wp-content\\/themes\\/Divi\\/includes\\/builder\\/frontend-builder\\/build\",\n                        \"path\": \"wp-content\\/themes\\/Divi\\/includes\\/builder\\/frontend-builder\\/build\\/bundle.js\"\n                    },\n                    {\n                        \"ubytes\": 6493184,\n                        \"bytes\": \"6.19MB\",\n                        \"nodes\": 1,\n                        \"name\": \"PISCINE-COQUE-BENDOR-3.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/01\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/01\\/PISCINE-COQUE-BENDOR-3.jpg\"\n                    },\n                    {\n                        \"ubytes\": 7100643,\n                        \"bytes\": \"6.77MB\",\n                        \"nodes\": 1,\n                        \"name\": \"PISCINE-COQUE-SYRNA-2-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/01\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/01\\/PISCINE-COQUE-SYRNA-2-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 6412288,\n                        \"bytes\": \"6.12MB\",\n                        \"nodes\": 1,\n                        \"name\": \"prado-plage-grise-4.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/01\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/01\\/prado-plage-grise-4.jpg\"\n                    },\n                    {\n                        \"ubytes\": 51410222,\n                        \"bytes\": \"49.03MB\",\n                        \"nodes\": 1,\n                        \"name\": \"catalogue-2025-v3-web.pdf\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/03\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/03\\/catalogue-2025-v3-web.pdf\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/elegancebq\\/www\\/.htaccess\",\n                    \"\\/home\\/elegancebq\\/www\\/.user.ini\",\n                    \"\\/home\\/elegancebq\\/www\\/php.ini\",\n                    \"\\/home\\/elegancebq\\/www\\/web.config\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-content\\/debug.log\",\n                    \"\\/home\\/elegancebq\\/www\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"xx0QezBBgqYem9jZK0IaA0QSPQeUqGmigTWaHjx3EQlo\\/ZCGJ9b68gu+646ZZLc1qcgRcQpTJ5mu3LPjygqAfQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"elegancebqprod25\",\n            \"tablesBaseCount\": 95,\n            \"tablesFinalCount\": 95,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 18835,\n            \"tablesSizeOnDisk\": 45252608,\n            \"tablesList\": {\n                \"wpeps_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"301\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_comments\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 1261568\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"wpeps_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_itsec_logs\": {\n                    \"inaccurateRows\": \"419\",\n                    \"insertedRows\": 0,\n                    \"size\": 442368\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_actions\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"inaccurateRows\": \"381\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_nf3_fields\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"inaccurateRows\": \"116\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_objects\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_options\": {\n                    \"inaccurateRows\": \"1090\",\n                    \"insertedRows\": 0,\n                    \"size\": 4554752\n                },\n                \"wpeps_postmeta\": {\n                    \"inaccurateRows\": \"5403\",\n                    \"insertedRows\": 0,\n                    \"size\": 9535488\n                },\n                \"wpeps_posts\": {\n                    \"inaccurateRows\": \"777\",\n                    \"insertedRows\": 0,\n                    \"size\": 18071552\n                },\n                \"wpeps_term_relationships\": {\n                    \"inaccurateRows\": \"2416\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_termmeta\": {\n                    \"inaccurateRows\": \"388\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_terms\": {\n                    \"inaccurateRows\": \"375\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_usermeta\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"1584\",\n                    \"insertedRows\": 0,\n                    \"size\": 360448\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"119\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"837\",\n                    \"insertedRows\": 0,\n                    \"size\": 5013504\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"982\",\n                    \"insertedRows\": 0,\n                    \"size\": 425984\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"450\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"1020\",\n                    \"insertedRows\": 0,\n                    \"size\": 671744\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"inaccurateRows\": \"481\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"479\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"inaccurateRows\": \"79\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.41\",\n            \"versionComment\": \"Percona Server (GPL), Release \'32\', Revision \'b8e378ec\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;32&#039;, Revision &#039;b8e378ec&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/elegancebq\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20250428_elegancepiscinesspas_da2217f92f4c36e91651_20250428060359_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": 17,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1745820609,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wpeps_users\",\n            \"wpeps_usermeta\",\n            \"wpeps_actionscheduler_actions\",\n            \"wpeps_actionscheduler_claims\",\n            \"wpeps_actionscheduler_groups\",\n            \"wpeps_actionscheduler_logs\",\n            \"wpeps_cmplz_cookiebanners\",\n            \"wpeps_cmplz_cookies\",\n            \"wpeps_cmplz_dnsmpd\",\n            \"wpeps_cmplz_services\",\n            \"wpeps_commentmeta\",\n            \"wpeps_comments\",\n            \"wpeps_duplicator_backups\",\n            \"wpeps_duplicator_entities\",\n            \"wpeps_itsec_bans\",\n            \"wpeps_itsec_dashboard_events\",\n            \"wpeps_itsec_dashboard_lockouts\",\n            \"wpeps_itsec_distributed_storage\",\n            \"wpeps_itsec_fingerprints\",\n            \"wpeps_itsec_firewall_rules\",\n            \"wpeps_itsec_geolocation_cache\",\n            \"wpeps_itsec_lockouts\",\n            \"wpeps_itsec_logs\",\n            \"wpeps_itsec_mutexes\",\n            \"wpeps_itsec_opaque_tokens\",\n            \"wpeps_itsec_temp\",\n            \"wpeps_itsec_user_groups\",\n            \"wpeps_itsec_vulnerabilities\",\n            \"wpeps_itsec_webauthn_credentials\",\n            \"wpeps_itsec_webauthn_users\",\n            \"wpeps_links\",\n            \"wpeps_nf3_action_meta\",\n            \"wpeps_nf3_actions\",\n            \"wpeps_nf3_chunks\",\n            \"wpeps_nf3_field_meta\",\n            \"wpeps_nf3_fields\",\n            \"wpeps_nf3_form_meta\",\n            \"wpeps_nf3_forms\",\n            \"wpeps_nf3_object_meta\",\n            \"wpeps_nf3_objects\",\n            \"wpeps_nf3_relationships\",\n            \"wpeps_nf3_upgrades\",\n            \"wpeps_options\",\n            \"wpeps_postmeta\",\n            \"wpeps_posts\",\n            \"wpeps_term_relationships\",\n            \"wpeps_term_taxonomy\",\n            \"wpeps_termmeta\",\n            \"wpeps_terms\",\n            \"wpeps_wc_admin_note_actions\",\n            \"wpeps_wc_admin_notes\",\n            \"wpeps_wc_category_lookup\",\n            \"wpeps_wc_customer_lookup\",\n            \"wpeps_wc_download_log\",\n            \"wpeps_wc_order_addresses\",\n            \"wpeps_wc_order_coupon_lookup\",\n            \"wpeps_wc_order_operational_data\",\n            \"wpeps_wc_order_product_lookup\",\n            \"wpeps_wc_order_stats\",\n            \"wpeps_wc_order_tax_lookup\",\n            \"wpeps_wc_orders\",\n            \"wpeps_wc_orders_meta\",\n            \"wpeps_wc_product_attributes_lookup\",\n            \"wpeps_wc_product_download_directories\",\n            \"wpeps_wc_product_meta_lookup\",\n            \"wpeps_wc_rate_limits\",\n            \"wpeps_wc_reserved_stock\",\n            \"wpeps_wc_tax_rate_classes\",\n            \"wpeps_wc_webhooks\",\n            \"wpeps_woocommerce_api_keys\",\n            \"wpeps_woocommerce_attribute_taxonomies\",\n            \"wpeps_woocommerce_downloadable_product_permissions\",\n            \"wpeps_woocommerce_log\",\n            \"wpeps_woocommerce_order_itemmeta\",\n            \"wpeps_woocommerce_order_items\",\n            \"wpeps_woocommerce_payment_tokenmeta\",\n            \"wpeps_woocommerce_payment_tokens\",\n            \"wpeps_woocommerce_sessions\",\n            \"wpeps_woocommerce_shipping_zone_locations\",\n            \"wpeps_woocommerce_shipping_zone_methods\",\n            \"wpeps_woocommerce_shipping_zones\",\n            \"wpeps_woocommerce_tax_rate_locations\",\n            \"wpeps_woocommerce_tax_rates\",\n            \"wpeps_woof_query_cache\",\n            \"wpeps_woof_sd\",\n            \"wpeps_woof_sd_presets\",\n            \"wpeps_wpr_above_the_fold\",\n            \"wpeps_wpr_lazy_render_content\",\n            \"wpeps_wpr_rocket_cache\",\n            \"wpeps_wpr_rucss_used_css\",\n            \"wpeps_yoast_indexable\",\n            \"wpeps_yoast_indexable_hierarchy\",\n            \"wpeps_yoast_migrations\",\n            \"wpeps_yoast_primary_term\",\n            \"wpeps_yoast_seo_links\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1745820586.495872,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 18835,\n            \"tables\": {\n                \"wpeps_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_cmplz_cookiebanners\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_cmplz_cookies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_cmplz_dnsmpd\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_cmplz_services\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_bans\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_dashboard_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_dashboard_lockouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_distributed_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_fingerprints\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_firewall_rules\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_geolocation_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_lockouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_mutexes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_opaque_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_temp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_user_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_vulnerabilities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_webauthn_credentials\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_itsec_webauthn_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_action_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_chunks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_field_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_object_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_objects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_nf3_upgrades\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woof_query_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woof_sd\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_woof_sd_presets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wpr_lazy_render_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_yoast_indexable\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_yoast_indexable_hierarchy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_yoast_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_yoast_primary_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpeps_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-28 06:03:59\",\n    \"updated\": \"2025-04-28 06:10:09\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.21.2","2025-04-28 06:03:59","2025-04-28 06:10:09");

INSERT IGNORE INTO `wpeps_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"never\",\n    \"email_summary_recipients\": [\n        \"contact@elegance-piscines-spas.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"contact@elegance-piscines-spas.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/elegance-piscines-spas.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"withhash\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"tech@anewstory.fr\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"purgeBackupRecords\": 0,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1741854825,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-04-03 12:21:04\"\n}","4.5.21.2","2025-03-13 08:33:44","2025-04-03 12:21:04"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-04-03 12:21:04\"\n}","4.5.21.2","2025-03-13 08:33:44","2025-04-03 12:21:04"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"ZnLYEhas7gCMEgBGjJ9y9RotVR2ey9wxDg\\/kAgQv7n44bhOhwWeAf62hM4S53QS51vA8XC5q8eZm1nrx7+k4oV9Isol9YlQtJdMWbXHNQSSms8YKefHk7slyfb2LVebKQCfugjU8YFj+J1w5UONG+J5Rk\\/WbtIsBd\\/e936A4MTLJJ4HCe4PVKiLgsRPoZu9bwRAdXHDdqiCJfobMRR5sArP\\/26Qf\\/XtsHuaF7us0YZ2aQj6LHQSSoQ==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-04-03 12:21:04\"\n}","4.5.21.2","2025-03-13 08:33:44","2025-04-03 12:21:04"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": {\n        \"16\": [\n            2,\n            6,\n            8,\n            10,\n            12,\n            14,\n            16,\n            18,\n            20,\n            22,\n            24,\n            26,\n            28,\n            30,\n            32,\n            34,\n            36,\n            38,\n            40,\n            42,\n            44,\n            46,\n            48,\n            50,\n            52,\n            54\n        ],\n        \"17\": [\n            3,\n            7,\n            9,\n            11,\n            13,\n            19,\n            21,\n            23,\n            25,\n            27,\n            31,\n            33,\n            35,\n            37,\n            39,\n            41,\n            43,\n            45,\n            47,\n            49,\n            51,\n            53\n        ],\n        \"18\": [\n            4\n        ],\n        \"19\": [\n            5\n        ]\n    },\n    \"failedPackageIds\": [\n        15,\n        17,\n        29\n    ],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": {\n        \"12\": 26,\n        \"13\": 22,\n        \"14\": 1,\n        \"15\": 1\n    },\n    \"scheduleIds\": [\n        16,\n        17,\n        18,\n        19\n    ],\n    \"storageIds\": [\n        12,\n        13,\n        14,\n        15\n    ],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-04-28 00:01:48\"\n}","4.5.21.2","0000-00-00 00:00:00","2025-04-28 00:01:48"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"e+cAZQPhIGki4xz15Nws6rwmUiLv+AR6i4iW9TTkQwq+n3MS19WjUOiFqfb7dKml\\/2VacKRZ8rOAjS07iJ9Hsg==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-03-13 08:33:44\"\n}","4.5.20.1","2025-03-13 08:33:44","2025-03-13 08:33:44"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"woIDL7pLQUVZ9H4SHa0xCGj4h9EwTA24sjr\\/baYVfxee3RETRO19On7lyWxAyoGaDr7rhsAlG7oMz6tzcmQZyg==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-04-01 13:19:58\"\n}","4.5.20.1","2025-03-13 08:33:44","2025-04-01 13:19:58"),
("7","Dynamic_Entity","","","","","","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-03-13 08:33:45\"\n}","4.5.20.1","2025-03-13 08:33:44","2025-03-13 08:33:45"),
("8","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"GLHn7EAH2EiFK5w9EYhOMAhKNAJkZJzpaJInRbkSTaU+4U3Mlk+TH98hxKAHSDX0kQ4GesaNBMBbWxRdo9Wr9SLwgkIz5vw95HuL8KJZY6uO6Xo6XTm7xuWkl+BQLa88\",\n    \"status\": \"hRZIQW3OLvLYPh5wJHn+W5WSOuU7WZNYRYQXQ3eFWOd4ilFgXTu2I0ImmPur0JMfl\\/KXqUcy6njQ9ZqLXCW8+3EMF\\/VGR5wG\",\n    \"type\": \"M6tYa7b2m7YHaXvae6eTefJ0H1+DrVURijGkPBurVh+s7f4GZuZHOkA4nv1w+T7RYH+FAp\\/NbHyl6duhZMyAQoLFYnV2fpDS\",\n    \"data\": \"3LA88gwZDpB9mw0FutA8EfWl3nADejCUyoRmX27HpwOCjtOVlPuSdMC0BBsNo6xhBKSnXT0Nf1vbAitZ9aPEMjbL9lLigYspDRLUdaOoWthbxYKAiiJnaFwY24tBL2eITBetz5jGv+XElvB78MpnBxqljHzSbehHG\\/7DVXV8ai\\/kAfXQALnvgJjVzODdSSoaGNo5Gwz+eGjXY6UsBsaQdrLKNhQP69RQe4VfSHtLiN+JATTN04+Pv1Hp8rJjVLLLn8ewu\\/x1mOGFCDr7fNgl63hPUwZRo\\/qJBpfHI62a1diUNdLcenzNXIUIOvt82CXrzXW+oLKigDOilr2n1uRbCbQr\\/\\/PuwgepcInMdX2qoqhl74I4fbzQBDaewn+5uPXob9fp4jjCmnm1o\\/ySn6jgyQ1dt57O9chXgSpxMTBHHUdElAvQ+lF7IzxwEbigYRgVEfQOOrw9Z6ZeYpK41tjw0fYCQg1qrsWGJhUm20nk87CNvkyxIM\\/cjuGcNOgG+1lCShI9dS0RlFlHWuWMTPJ5RKFYuQv2QyPU\",\n    \"lastRemoteUpdate\": \"2025-04-24 12:27:58\",\n    \"lastFailureTime\": \"\",\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-03-13 08:33:44\",\n    \"updated\": \"2025-04-24 12:27:58\"\n}","4.5.21.2","2025-03-13 08:33:44","2025-04-24 12:27:58"),
("9","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1745820605,\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-03-13 08:33:46\",\n    \"updated\": \"2025-04-28 06:10:05\"\n}","4.5.21.2","2025-03-13 08:33:46","2025-04-28 06:10:05"),
("10","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"All\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"sJQwTIxizhkZweGxSg6xqopcAUNegFsqS5B6Q7P3jR6DbbZuu7ITscZk0UgA3bTAqKid1vl8WIRQxFX5nyKl8g==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": \"-1\",\n    \"is_default\": false,\n    \"is_manual\": false,\n    \"id\": 10,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:17:06\",\n    \"updated\": \"2025-04-03 09:17:06\"\n}","4.5.20.1","2025-04-03 09:17:06","2025-04-03 09:17:06"),
("11","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Backup_bdd\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"UuBOGXaLK58kDI1+nUSOSbbGhytSQWTwLPV1cOVcyj5rBH\\/i68QVZ5rw7yLZWAYrHKp1WkD7Z\\/vhu9KzZBBUcA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": \"-1\",\n    \"is_default\": false,\n    \"is_manual\": false,\n    \"id\": 11,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:17:27\",\n    \"updated\": \"2025-04-03 09:17:38\"\n}","4.5.20.1","2025-04-03 09:17:27","2025-04-03 09:17:38"),
("12","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Backup_bdd\",\n    \"notes\": \"\",\n    \"storage_type\": 0,\n    \"config\": \"TBKohl6VS5eSnnK7GfJIK9ZYkl+MGlZ+rnd07kX59WI4bhOhwWeAf62hM4S53QS51vA8XC5q8eZm1nrx7+k4oV9Isol9YlQtMcfLUP4rCqLzpeWz9MG2717uzQvD5QpeeIyq2zZNuO5XF1Yd5TXVGfSKHc3Ru\\/z2BbjWUYZa7XBESeX48BTK7sTHmJrz\\/yvISi42wYdARyhzofti2HnvnUwMQW1LNNnn\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 12,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:21:25\",\n    \"updated\": \"2025-04-03 09:21:25\"\n}","4.5.20.1","2025-04-03 09:21:25","2025-04-03 09:21:25"),
("13","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Backup_all\",\n    \"notes\": \"\",\n    \"storage_type\": 0,\n    \"config\": \"bZUijUqfYOYZywa0rrjoQ4dFifH3R5+dF0iB+0yqNc84bhOhwWeAf62hM4S53QS51vA8XC5q8eZm1nrx7+k4oV9Isol9YlQtMcfLUP4rCqLzpeWz9MG27wdaxhZgnaGaeIyq2zZNuO4OHthfquvNQfSKHc3Ru\\/z2BbjWUYZa7XBESeX48BTK7hZhrjMgv7Fj6ODfsOPK96OaSI7MxV7+iidhoHQ5fcjH\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 13,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:22:00\",\n    \"updated\": \"2025-04-03 09:22:00\"\n}","4.5.20.1","2025-04-03 09:22:00","2025-04-03 09:22:00"),
("14","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Backup_monthly\",\n    \"notes\": \"\",\n    \"storage_type\": 1,\n    \"config\": \"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\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 14,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:22:53\",\n    \"updated\": \"2025-04-03 09:23:00\"\n}","4.5.20.1","2025-04-03 09:22:53","2025-04-03 09:23:00"),
("15","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Backup_semester\",\n    \"notes\": \"\",\n    \"storage_type\": 1,\n    \"config\": \"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\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 15,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:23:49\",\n    \"updated\": \"2025-04-03 09:24:06\"\n}","4.5.20.1","2025-04-03 09:23:49","2025-04-03 09:24:06"),
("16","DUP_PRO_Schedule_Entity","","","","","","{\n    \"name\": \"Backup_bdd\",\n    \"template_id\": 11,\n    \"start_ticks\": 1420077600,\n    \"repeat_type\": 0,\n    \"active\": true,\n    \"next_run_time\": 1745884800,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 2 * * *\",\n    \"last_run_time\": 1745798510,\n    \"last_run_status\": 0,\n    \"times_run\": 26,\n    \"storage_ids\": [\n        12\n    ],\n    \"id\": 16,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-03 09:24:53\",\n    \"updated\": \"2025-04-28 00:01:50\"\n}","4.5.21.2","2025-04-03 09:24:53","2025-04-28 00:01:50"),
("17","DUP_PRO_Schedule_Entity","","","","","","{\n    \"name\": \"Backup_all\",\n    \"template_id\": 10,\n    \"start_ticks\": 1420099200,\n    \"repeat_type\": 0,\n    \"active\": true,\n    \"next_run_time\": 1745906400,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 8 * * *\",\n    \"last_run_time\": 1745735813,\n    \"last_run_status\": 0,\n    \"times_run\": 28,\n    \"storage_ids\": [\n        13\n    ],\n    \"id\": 17,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-03 09:25:31\",\n    \"updated\": \"2025-04-28 06:04:00\"\n}","4.5.21.2","2025-04-03 09:25:31","2025-04-28 06:04:00"),
("18","DUP_PRO_Schedule_Entity","","","","","","{\n    \"name\": \"Backup_monthly\",\n    \"template_id\": 10,\n    \"start_ticks\": 1420146000,\n    \"repeat_type\": 2,\n    \"active\": true,\n    \"next_run_time\": 1746212400,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 2,\n    \"cron_string\": \"0 21 2 * *\",\n    \"last_run_time\": 1743673493,\n    \"last_run_status\": 0,\n    \"times_run\": 1,\n    \"storage_ids\": [\n        14\n    ],\n    \"id\": 18,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20.1\",\n    \"created\": \"2025-04-03 09:26:13\",\n    \"updated\": \"2025-04-03 09:44:53\"\n}","4.5.20.1","2025-04-03 09:26:13","2025-04-03 09:44:53"),
("19","DUP_PRO_Schedule_Entity","","","","","","{\n    \"name\": \"Backup_semester\",\n    \"template_id\": 10,\n    \"start_ticks\": 1420149600,\n    \"repeat_type\": 2,\n    \"active\": true,\n    \"next_run_time\": 1752696000,\n    \"run_every\": 6,\n    \"weekly_days\": 0,\n    \"day_of_month\": 16,\n    \"cron_string\": \"0 22 16 *\\/6 *\",\n    \"last_run_time\": 1743684239,\n    \"last_run_status\": 0,\n    \"times_run\": 1,\n    \"storage_ids\": [\n        15\n    ],\n    \"id\": 19,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"2025-04-03 09:26:53\",\n    \"updated\": \"2025-04-03 12:43:59\"\n}","4.5.21.2","2025-04-03 09:26:53","2025-04-03 12:43:59");

INSERT IGNORE INTO `wpeps_itsec_dashboard_events` VALUES 
("11","vm-update-plugin","2025-04-03 00:00:00","9","1"),
("12","vm-update-theme","2025-04-03 00:00:00","1","1"),
("14","vm-update-core","2025-04-16 00:00:00","1","1");

INSERT IGNORE INTO `wpeps_itsec_logs` VALUES 
("1","0","user_logging","plugin-activated::ithemes-security-pro/ithemes-security-pro.php,","b:0;","notice","2025-04-03 08:59:46","2025-04-03 08:59:44","122186832","123645560","https://elegance-piscines-spas.com/wp-admin/plugins.php?action=activate&plugin=ithemes-security-pro%2Fithemes-security-pro.php&plugin_status=all&paged=1&s&_wpnonce=4fbbe04f0a","1","2","81.65.182.113"),
("2","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-03 09:04:08","2025-04-03 09:04:08","121562784","127165136","https://elegance-piscines-spas.com/wp-login.php","1","0","81.65.182.113"),
("3","0","notification_center","send::hide-backend","a:2:{s:10:\"recipients\";a:1:{i:0;s:20:\"contact@anewstory.fr\";}s:7:\"subject\";s:60:\"[elegance-piscines-spas.com] WordPress Login Address Changed\";}","debug","2025-04-03 09:04:54","2025-04-03 09:04:53","136577792","137868008","https://elegance-piscines-spas.com/wp-json/batch/v1?_locale=user","1","2","81.65.182.113"),
("4","0","notification_center","send::hide-backend","a:2:{s:10:\"recipients\";a:1:{i:0;s:20:\"contact@anewstory.fr\";}s:7:\"subject\";s:60:\"[elegance-piscines-spas.com] WordPress Login Address Changed\";}","debug","2025-04-03 09:07:42","2025-04-03 09:07:41","136600048","137893072","https://elegance-piscines-spas.com/wp-json/batch/v1?_locale=user","1","2","81.65.182.113"),
("5","0","user_logging","plugin-activated::wp-rocket/wp-rocket.php,","b:0;","notice","2025-04-03 09:09:35","2025-04-03 09:09:32","123121992","123192888","https://elegance-piscines-spas.com/wp-admin/plugins.php?plugin_status=all&paged=1&s","1","2","81.65.182.113"),
("6","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-03 09:15:10","2025-04-03 09:15:05","123861424","126944016","wp-cron","1","0","54.37.121.239"),
("7","6","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.11\";s:7:\"akismet\";s:5:\"5.3.3\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.20.1\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:20:\"ithemes-security-pro\";s:5:\"7.3.0\";s:11:\"ninja-forms\";s:6:\"3.8.21\";s:17:\"ninja-forms-style\";s:6:\"3.0.29\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:8:\"3.12.5.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.0\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.0\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"c97921b135fdace0cb0027bfba8dc52abf6211dd\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-03 09:15:11","2025-04-03 09:15:05","124184440","126944016","wp-cron","1","0","54.37.121.239"),
("8","6","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-a5a9a59f8e8777925ad521e75dd65eeb\";}","process-update","2025-04-03 09:15:11","2025-04-03 09:15:05","124244944","126944016","wp-cron","1","0","54.37.121.239"),
("9","6","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.0\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:1:{i:0;a:4:{s:4:\"type\";s:6:\"plugin\";s:8:\"software\";a:3:{s:4:\"slug\";s:11:\"ninja-forms\";s:5:\"label\";s:11:\"Ninja Forms\";s:14:\"latest_version\";N;}s:6:\"issues\";a:2:{i:0;a:16:{s:5:\"title\";s:125:\"WordPress Ninja Forms plugin <= 3.8.24 - Authenticated (Contributor+) Stored Cross-Site Scripting via Shortcode vulnerability\";s:11:\"description\";s:167:\"Authenticated (Contributor+) Stored Cross-Site Scripting via Shortcode vulnerability discovered by Peter Thaleikis in WordPress Plugin Ninja Forms (versions <= 3.8.24)\";s:11:\"affected_in\";s:9:\"<= 3.8.24\";s:8:\"fixed_in\";s:6:\"3.8.25\";s:10:\"references\";a:2:{i:0;a:3:{s:4:\"slug\";s:10:\"patchstack\";s:5:\"label\";s:10:\"PatchStack\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:117:\"wordpress-ninja-forms-plugin-3-8-24-authenticated-contributor-stored-cross-site-scripting-via-shortcode-vulnerability\";s:5:\"label\";s:7:\"Details\";s:4:\"link\";s:185:\"https://patchstack.com/database/vulnerability/ninja-forms/wordpress-ninja-forms-plugin-3-8-24-authenticated-contributor-stored-cross-site-scripting-via-shortcode-vulnerability?_a_id=431\";}}}i:1;a:3:{s:4:\"slug\";s:3:\"cve\";s:5:\"label\";s:3:\"CVE\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:10:\"2024-13470\";s:5:\"label\";s:10:\"2024-13470\";s:4:\"link\";s:47:\"https://www.cve.org/CVERecord?id=CVE-2024-13470\";}}}}s:4:\"type\";a:2:{s:5:\"label\";s:26:\"Cross Site Scripting (XSS)\";s:4:\"slug\";s:0:\"\";}s:2:\"id\";s:8:\"ps-26821\";s:10:\"created_at\";s:25:\"2025-01-30T07:28:45+00:00\";s:10:\"updated_at\";s:25:\"2025-01-30T07:28:45+00:00\";s:12:\"published_at\";s:25:\"2025-01-30T07:28:34+00:00\";s:5:\"score\";d:6.5;s:11:\"score_group\";s:0:\"\";s:12:\"score_vector\";s:0:\"\";s:12:\"is_exploited\";b:0;s:17:\"patched_in_ranges\";a:0:{}s:14:\"patch_priority\";i:1;}i:1;a:16:{s:5:\"title\";s:112:\"WordPress Ninja Forms plugin <= 3.8.22 - Authenticated (Subscriber+) Arbitrary Shortcode Execution vulnerability\";s:11:\"description\";s:148:\"Authenticated (Subscriber+) Arbitrary Shortcode Execution vulnerability discovered by mikemyers in WordPress Plugin Ninja Forms (versions <= 3.8.22)\";s:11:\"affected_in\";s:9:\"<= 3.8.22\";s:8:\"fixed_in\";s:6:\"3.8.23\";s:10:\"references\";a:2:{i:0;a:3:{s:4:\"slug\";s:10:\"patchstack\";s:5:\"label\";s:10:\"PatchStack\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:104:\"wordpress-ninja-forms-plugin-3-8-22-authenticated-subscriber-arbitrary-shortcode-execution-vulnerability\";s:5:\"label\";s:7:\"Details\";s:4:\"link\";s:172:\"https://patchstack.com/database/vulnerability/ninja-forms/wordpress-ninja-forms-plugin-3-8-22-authenticated-subscriber-arbitrary-shortcode-execution-vulnerability?_a_id=431\";}}}i:1;a:3:{s:4:\"slug\";s:3:\"cve\";s:5:\"label\";s:3:\"CVE\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:10:\"2024-12238\";s:5:\"label\";s:10:\"2024-12238\";s:4:\"link\";s:47:\"https://www.cve.org/CVERecord?id=CVE-2024-12238\";}}}}s:4:\"type\";a:2:{s:5:\"label\";s:24:\"Arbitrary Code Execution\";s:4:\"slug\";s:0:\"\";}s:2:\"id\";s:8:\"ps-25430\";s:10:\"created_at\";s:25:\"2024-12-30T06:28:48+00:00\";s:10:\"updated_at\";s:25:\"2024-12-30T06:28:48+00:00\";s:12:\"published_at\";s:25:\"2024-12-30T06:25:28+00:00\";s:5:\"score\";d:6.3;s:11:\"score_group\";s:0:\"\";s:12:\"score_vector\";s:0:\"\";s:12:\"is_exploited\";b:0;s:17:\"patched_in_ranges\";a:0:{}s:14:\"patch_priority\";i:2;}}s:4:\"link\";s:605:\"https://itsec-site-scanner.ithemes.com/vulnerability-details/djIubG9jYWwuc0VzanRNN1N5U0IwT0tUZEZfS1ItMVJoU2I3bllybjJsbnEzcWZodTQxREl5RXdOb3VXT3VXOEZWVGVqWHFlN1g5MXViSWZ2dEVJZEhFMm9YYW12a1F5UVNpejV3UXFLTG8ydzh3X3NQY0xsNmtVY1ozRF9YTURpYm1SQlZleTVtNUVGRTlGalljcEVTTE9CMzJBT29nSnpRTV92Z2NvZmRQOEJKRVJYdVJ2N1JSalNxZ29kTUhsZFZSai0zWXA4S0FmWGY2S0EzUW9Ka3k1eFdRSFRYQnFCM0xwY0FWdXcwWU9WdVVGd2sybVJWNkZGWXpTT0tRUUVkV3drSF9DOWt4dG1VZDdkTDNDYVdQVWF4ZUdzdGpreU5oaFpoSlYweG1NaHlVWkpjYm9XeGQ2d0dlcV9ZT2lxV3lRUk1CZjRHMTlhYmJtZ3ZQaGNfY1g2QVdkai1mQzRkRGp2cXhHWkxvZXc3Ul9CV2lZSlcyRTlESTVUWUNMNGYyVlNXckZhS1V4NEFnODdLZ2c%253D\";}}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-03 09:15:11","2025-04-03 09:15:05","124205560","126944016","wp-cron","1","0","54.37.121.239"),
("10","0","site-scanner","vulnerable-software","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.0\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:1:{i:0;a:4:{s:4:\"type\";s:6:\"plugin\";s:8:\"software\";a:3:{s:4:\"slug\";s:11:\"ninja-forms\";s:5:\"label\";s:11:\"Ninja Forms\";s:14:\"latest_version\";N;}s:6:\"issues\";a:2:{i:0;a:16:{s:5:\"title\";s:125:\"WordPress Ninja Forms plugin <= 3.8.24 - Authenticated (Contributor+) Stored Cross-Site Scripting via Shortcode vulnerability\";s:11:\"description\";s:167:\"Authenticated (Contributor+) Stored Cross-Site Scripting via Shortcode vulnerability discovered by Peter Thaleikis in WordPress Plugin Ninja Forms (versions <= 3.8.24)\";s:11:\"affected_in\";s:9:\"<= 3.8.24\";s:8:\"fixed_in\";s:6:\"3.8.25\";s:10:\"references\";a:2:{i:0;a:3:{s:4:\"slug\";s:10:\"patchstack\";s:5:\"label\";s:10:\"PatchStack\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:117:\"wordpress-ninja-forms-plugin-3-8-24-authenticated-contributor-stored-cross-site-scripting-via-shortcode-vulnerability\";s:5:\"label\";s:7:\"Details\";s:4:\"link\";s:185:\"https://patchstack.com/database/vulnerability/ninja-forms/wordpress-ninja-forms-plugin-3-8-24-authenticated-contributor-stored-cross-site-scripting-via-shortcode-vulnerability?_a_id=431\";}}}i:1;a:3:{s:4:\"slug\";s:3:\"cve\";s:5:\"label\";s:3:\"CVE\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:10:\"2024-13470\";s:5:\"label\";s:10:\"2024-13470\";s:4:\"link\";s:47:\"https://www.cve.org/CVERecord?id=CVE-2024-13470\";}}}}s:4:\"type\";a:2:{s:5:\"label\";s:26:\"Cross Site Scripting (XSS)\";s:4:\"slug\";s:0:\"\";}s:2:\"id\";s:8:\"ps-26821\";s:10:\"created_at\";s:25:\"2025-01-30T07:28:45+00:00\";s:10:\"updated_at\";s:25:\"2025-01-30T07:28:45+00:00\";s:12:\"published_at\";s:25:\"2025-01-30T07:28:34+00:00\";s:5:\"score\";d:6.5;s:11:\"score_group\";s:0:\"\";s:12:\"score_vector\";s:0:\"\";s:12:\"is_exploited\";b:0;s:17:\"patched_in_ranges\";a:0:{}s:14:\"patch_priority\";i:1;}i:1;a:16:{s:5:\"title\";s:112:\"WordPress Ninja Forms plugin <= 3.8.22 - Authenticated (Subscriber+) Arbitrary Shortcode Execution vulnerability\";s:11:\"description\";s:148:\"Authenticated (Subscriber+) Arbitrary Shortcode Execution vulnerability discovered by mikemyers in WordPress Plugin Ninja Forms (versions <= 3.8.22)\";s:11:\"affected_in\";s:9:\"<= 3.8.22\";s:8:\"fixed_in\";s:6:\"3.8.23\";s:10:\"references\";a:2:{i:0;a:3:{s:4:\"slug\";s:10:\"patchstack\";s:5:\"label\";s:10:\"PatchStack\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:104:\"wordpress-ninja-forms-plugin-3-8-22-authenticated-subscriber-arbitrary-shortcode-execution-vulnerability\";s:5:\"label\";s:7:\"Details\";s:4:\"link\";s:172:\"https://patchstack.com/database/vulnerability/ninja-forms/wordpress-ninja-forms-plugin-3-8-22-authenticated-subscriber-arbitrary-shortcode-execution-vulnerability?_a_id=431\";}}}i:1;a:3:{s:4:\"slug\";s:3:\"cve\";s:5:\"label\";s:3:\"CVE\";s:4:\"refs\";a:1:{i:0;a:3:{s:5:\"value\";s:10:\"2024-12238\";s:5:\"label\";s:10:\"2024-12238\";s:4:\"link\";s:47:\"https://www.cve.org/CVERecord?id=CVE-2024-12238\";}}}}s:4:\"type\";a:2:{s:5:\"label\";s:24:\"Arbitrary Code Execution\";s:4:\"slug\";s:0:\"\";}s:2:\"id\";s:8:\"ps-25430\";s:10:\"created_at\";s:25:\"2024-12-30T06:28:48+00:00\";s:10:\"updated_at\";s:25:\"2024-12-30T06:28:48+00:00\";s:12:\"published_at\";s:25:\"2024-12-30T06:25:28+00:00\";s:5:\"score\";d:6.3;s:11:\"score_group\";s:0:\"\";s:12:\"score_vector\";s:0:\"\";s:12:\"is_exploited\";b:0;s:17:\"patched_in_ranges\";a:0:{}s:14:\"patch_priority\";i:2;}}s:4:\"link\";s:605:\"https://itsec-site-scanner.ithemes.com/vulnerability-details/djIubG9jYWwuc0VzanRNN1N5U0IwT0tUZEZfS1ItMVJoU2I3bllybjJsbnEzcWZodTQxREl5RXdOb3VXT3VXOEZWVGVqWHFlN1g5MXViSWZ2dEVJZEhFMm9YYW12a1F5UVNpejV3UXFLTG8ydzh3X3NQY0xsNmtVY1ozRF9YTURpYm1SQlZleTVtNUVGRTlGalljcEVTTE9CMzJBT29nSnpRTV92Z2NvZmRQOEJKRVJYdVJ2N1JSalNxZ29kTUhsZFZSai0zWXA4S0FmWGY2S0EzUW9Ka3k1eFdRSFRYQnFCM0xwY0FWdXcwWU9WdVVGd2sybVJWNkZGWXpTT0tRUUVkV3drSF9DOWt4dG1VZDdkTDNDYVdQVWF4ZUdzdGpreU5oaFpoSlYweG1NaHlVWkpjYm9XeGQ2d0dlcV9ZT2lxV3lRUk1CZjRHMTlhYmJtZ3ZQaGNfY1g2QVdkai1mQzRkRGp2cXhHWkxvZXc3Ul9CV2lZSlcyRTlESTVUWUNMNGYyVlNXckZhS1V4NEFnODdLZ2c%253D\";}}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","critical-issue","2025-04-03 09:15:11","2025-04-03 09:15:05","124220280","126944016","wp-cron","1","0","54.37.121.239"),
("11","0","notification_center","send::malware-scheduling","a:2:{s:10:\"recipients\";a:1:{i:0;s:20:\"contact@anewstory.fr\";}s:7:\"subject\";s:76:\"[elegance-piscines-spas.com] Scheduled site scan report: Vulnerable Software\";}","debug","2025-04-03 09:15:11","2025-04-03 09:15:05","124762776","126944016","wp-cron","1","0","54.37.121.239"),
("12","0","version_management","update::plugin,advanced-custom-fields/acf.php,6.3.12,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131658600","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("13","0","version_management","update::plugin,akismet/akismet.php,5.3.7,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839224","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("14","0","version_management","update::plugin,divi-essential/divi-essential.php,4.9.11,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839104","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("15","0","version_management","update::plugin,duplicator-pro/duplicator-pro.php,4.5.21.2,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839136","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("16","0","version_management","update::plugin,ithemes-security-pro/ithemes-security-pro.php,8.5.4,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839120","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("17","0","version_management","update::plugin,ninja-forms/ninja-forms.php,3.10.0,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839344","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("18","0","version_management","update::plugin,ninja-forms-style/ninja-forms-style.php,3.0.30,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:27","2025-04-03 12:16:33","131839080","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("19","0","version_management","update::plugin,wp-rocket/wp-rocket.php,3.18.3,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"divi-essential/divi-essential.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:5;s:27:\"ninja-forms/ninja-forms.php\";i:6;s:39:\"ninja-forms-style/ninja-forms-style.php\";i:7;s:23:\"wp-rocket/wp-rocket.php\";}}}","notice","2025-04-03 12:17:28","2025-04-03 12:16:33","131839064","139245624","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=advanced-custom-fields%2Facf.php%2Cakismet%2Fakismet.php%2Cdivi-essential%2Fdivi-essential.php%2Cduplicator-pro%2Fduplicator-pro.php%2Cithemes-security-pro%2Fithemes-security-pro.php%2Cninja-forms%2Fninja-forms.php%2Cninja-forms-style%2Fninja-forms-style.php%2Cwp-rocket%2Fwp-rocket.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("20","0","version_management","update::plugin,divi-essential/divi-essential.php,4.9.11,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:1:{i:0;s:33:\"divi-essential/divi-essential.php\";}}}","notice","2025-04-03 12:21:46","2025-04-03 12:21:45","136103760","136223392","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected&plugins=divi-essential%2Fdivi-essential.php&_wpnonce=63c5f1ac8b","1","2","81.65.182.113"),
("21","0","version_management","update::theme,twentytwentyfive,1.1,manual","a:1:{s:7:\"context\";a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:5:\"theme\";s:4:\"bulk\";b:1;s:6:\"themes\";a:1:{i:0;s:16:\"twentytwentyfive\";}}}","notice","2025-04-03 12:22:04","2025-04-03 12:22:01","136225368","136508800","https://elegance-piscines-spas.com/wp-admin/update.php?action=update-selected-themes&themes=twentytwentyfive&_wpnonce=bbbad0039f","1","2","81.65.182.113"),
("22","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-03 13:11:49","2025-04-03 13:11:47","127208616","127296816","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("23","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-03 21:17:40","2025-04-03 21:17:38","129265456","130816520","wp-cron","1","0","54.37.121.239"),
("24","23","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-03 21:17:40","2025-04-03 21:17:38","129738832","130816520","wp-cron","1","0","54.37.121.239"),
("25","23","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-03 21:17:40","2025-04-03 21:17:38","129746064","130816520","wp-cron","1","0","54.37.121.239"),
("26","23","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-03 21:17:40","2025-04-03 21:17:38","129728056","130816520","wp-cron","1","0","54.37.121.239"),
("27","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-03 21:17:40","2025-04-03 21:17:38","129728312","130816520","wp-cron","1","0","54.37.121.239"),
("28","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-04 08:04:51","2025-04-04 08:04:49","128477800","128565920","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("29","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-04 08:59:53","2025-04-04 08:59:51","127691624","127810120","https://elegance-piscines-spas.com/wp-json/wp/v2/product/1949","1","0","3.143.25.56"),
("30","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-04 09:15:40","2025-04-04 09:15:39","128285312","129047008","wp-cron","1","0","54.37.121.239"),
("31","30","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-04 09:15:41","2025-04-04 09:15:39","129172936","129232320","wp-cron","1","0","54.37.121.239"),
("32","30","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-04 09:15:41","2025-04-04 09:15:39","129179416","129232320","wp-cron","1","0","54.37.121.239"),
("33","30","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-04 09:15:41","2025-04-04 09:15:39","129161408","129232320","wp-cron","1","0","54.37.121.239"),
("34","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-04 09:15:41","2025-04-04 09:15:39","129161664","129232320","wp-cron","1","0","54.37.121.239"),
("35","0","security-check-pro","start-scan","b:0;","process-start","2025-04-04 09:25:28","2025-04-04 09:25:27","127914856","128122616","wp-cron","1","0","54.37.121.239"),
("36","35","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-04 09:25:28","2025-04-04 09:25:27","128340208","128452800","wp-cron","1","0","54.37.121.239"),
("37","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-04 11:16:59","2025-04-04 11:16:58","127173912","127262112","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("38","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-04 14:51:14","2025-04-04 14:51:13","128379256","128467456","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","2","195.25.230.205"),
("39","0","version_management","auto-update","a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"9.7.1\";s:7:\"updated\";s:19:\"2025-04-04 13:15:28\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/woocommerce/9.7.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:64:\"/home/elegancebq/www/wp-content/upgrade/woocommerce-9.7.1-fr_fr/\";s:12:\"source_files\";a:275:{i:0;s:55:\"woocommerce-fr_FR-a5172fd12c10e6598faed8b2c4cd0a49.json\";i:1;s:55:\"woocommerce-fr_FR-2b2538420122030cea7c8d36028faff6.json\";i:2;s:55:\"woocommerce-fr_FR-74b6fb60d0b88b06aae7413389f85544.json\";i:3;s:55:\"woocommerce-fr_FR-a6d634ec8301cf8a951a8878c11a934b.json\";i:4;s:55:\"woocommerce-fr_FR-fe5bd46cad4d94d410bb4f072377120f.json\";i:5;s:55:\"woocommerce-fr_FR-c9aa30dc38bbe30edca1fe99018864fe.json\";i:6;s:55:\"woocommerce-fr_FR-921754054d88d50626fa24baf6ec95c0.json\";i:7;s:55:\"woocommerce-fr_FR-7a92e63be4e33f07197c750b116079d5.json\";i:8;s:55:\"woocommerce-fr_FR-c82d261e7ee918daf590ebaf0e1b1da4.json\";i:9;s:55:\"woocommerce-fr_FR-64a77239dfb2b1729c26a1a7c25245fc.json\";i:10;s:55:\"woocommerce-fr_FR-fb0e7e07600bfdd1b86bc3efe48e49ce.json\";i:11;s:55:\"woocommerce-fr_FR-638616813127815eec836b38d70517f5.json\";i:12;s:55:\"woocommerce-fr_FR-2445bfbce6188dfc1e617e7506a894ce.json\";i:13;s:55:\"woocommerce-fr_FR-fabda6b5672171db3d20defc3605c5a8.json\";i:14;s:55:\"woocommerce-fr_FR-8fce56bf08454a96ec50f1c54fd119f2.json\";i:15;s:55:\"woocommerce-fr_FR-8ac70ecf9ac8f6c68deba22867d20f3a.json\";i:16;s:55:\"woocommerce-fr_FR-c573e1c09e9366052819287a51fb565d.json\";i:17;s:55:\"woocommerce-fr_FR-85f8b8cc67d62cedf7d528975a786993.json\";i:18;s:55:\"woocommerce-fr_FR-66eb0f8993f9a1f59f27ad5b75ea6077.json\";i:19;s:55:\"woocommerce-fr_FR-b54f864938448a4bc37e2121fd6ea989.json\";i:20;s:55:\"woocommerce-fr_FR-202af67c0a3cdb5d8374095542b82c72.json\";i:21;s:55:\"woocommerce-fr_FR-35badc913c2594f0b9f19d36b58b9cce.json\";i:22;s:55:\"woocommerce-fr_FR-f0956c00c9e045d83f878249d69958bd.json\";i:23;s:55:\"woocommerce-fr_FR-300a9bbfa15ee1cf558675d4527a387e.json\";i:24;s:55:\"woocommerce-fr_FR-0c6d24e76fb42f9c601d7dd21391d326.json\";i:25;s:55:\"woocommerce-fr_FR-b660710d20aa544ac71a551eec7101a4.json\";i:26;s:55:\"woocommerce-fr_FR-fc7887bbe75b0041310c11444355aabf.json\";i:27;s:55:\"woocommerce-fr_FR-530b01a91640e4b045d957344718894e.json\";i:28;s:55:\"woocommerce-fr_FR-48f712bf18d189801e4ae706e0037377.json\";i:29;s:55:\"woocommerce-fr_FR-88a8737dc981dd844f44b769c031c35d.json\";i:30;s:55:\"woocommerce-fr_FR-f34beaf9c94fc969fe091bdb0a3d06e7.json\";i:31;s:55:\"woocommerce-fr_FR-0d6604f2b4e5dcbcc7fb3013a9a6d17d.json\";i:32;s:55:\"woocommerce-fr_FR-8aae233d6340dd7cca1b1cb672956a2f.json\";i:33;s:55:\"woocommerce-fr_FR-452ce70241ca22cfa3d369e7eaf12b03.json\";i:34;s:55:\"woocommerce-fr_FR-1b48a41aeb3290448ede10e6210481e4.json\";i:35;s:55:\"woocommerce-fr_FR-b2ae7f9ba389c86776f28fb5f7376335.json\";i:36;s:55:\"woocommerce-fr_FR-7e9f53f8275f2428f994fbcd6b09f9cb.json\";i:37;s:55:\"woocommerce-fr_FR-ddc852e3baa9cc9f15df8f712b00e24c.json\";i:38;s:55:\"woocommerce-fr_FR-1d36dd58e9841b6509a2e3f0d219e98b.json\";i:39;s:55:\"woocommerce-fr_FR-5a46c0880461d4dc5eb91cd66679410c.json\";i:40;s:55:\"woocommerce-fr_FR-64a6f1e5301cb5a60ed66105cff1fb9d.json\";i:41;s:55:\"woocommerce-fr_FR-2ac87a601295112b7c1db6c968c1d4f9.json\";i:42;s:55:\"woocommerce-fr_FR-a774ade9a14e03f8650b90217755c77c.json\";i:43;s:55:\"woocommerce-fr_FR-6bd75bb58189aed7804a8e3dbb6eb0e5.json\";i:44;s:55:\"woocommerce-fr_FR-c2394a0736134d667e4a1433bd9ef288.json\";i:45;s:55:\"woocommerce-fr_FR-a68c8976356205524b4aff13de002f20.json\";i:46;s:55:\"woocommerce-fr_FR-268d1111eddac83f6cfa3013b0277955.json\";i:47;s:55:\"woocommerce-fr_FR-973a6b59201519d875b78a238c6a67a4.json\";i:48;s:55:\"woocommerce-fr_FR-181ce41a6826e43d33e176d72f1da0dd.json\";i:49;s:55:\"woocommerce-fr_FR-9d59fc010f6d8ff895aa009384b04b57.json\";i:50;s:55:\"woocommerce-fr_FR-faf42d095a2280fdadded6bcc7f5600b.json\";i:51;s:20:\"woocommerce-fr_FR.mo\";i:52;s:55:\"woocommerce-fr_FR-2c99303d18ce23c3379a94c74d3a5726.json\";i:53;s:55:\"woocommerce-fr_FR-c58638c50f7298ef6598e7bd0a1ad65c.json\";i:54;s:55:\"woocommerce-fr_FR-31f155bff663a5e2e6814d812cb59a41.json\";i:55;s:55:\"woocommerce-fr_FR-e9da8c17aa451807d92b07bc51a8029b.json\";i:56;s:55:\"woocommerce-fr_FR-d339e188a3dc8a77b4e5c83406464a43.json\";i:57;s:55:\"woocommerce-fr_FR-4ef3118a4b5a865d0934d771a1a875a5.json\";i:58;s:55:\"woocommerce-fr_FR-d8234f4b8220bdb74a7d7270633ddaf0.json\";i:59;s:55:\"woocommerce-fr_FR-319f63b6d11179df948f1e1c4039f238.json\";i:60;s:55:\"woocommerce-fr_FR-65c453b99754c5ecb86a000f47491ca5.json\";i:61;s:55:\"woocommerce-fr_FR-325d05a45405811cc4e3bc3480e1273a.json\";i:62;s:55:\"woocommerce-fr_FR-a2f0c42630973925852130fb37b2eab0.json\";i:63;s:55:\"woocommerce-fr_FR-c29610f8145dddacaacc3361e77a1274.json\";i:64;s:55:\"woocommerce-fr_FR-99c04baaa4b5f1a947031d73ac938985.json\";i:65;s:55:\"woocommerce-fr_FR-3689e3982a54d5dbb8c20c49e9cf24fa.json\";i:66;s:55:\"woocommerce-fr_FR-78028b4b612742fc96407a351e0198e9.json\";i:67;s:55:\"woocommerce-fr_FR-98cb3428b01292ea31f2d1e0394acaaa.json\";i:68;s:55:\"woocommerce-fr_FR-35f5d74f2007b126eeef3c73a7c819a6.json\";i:69;s:55:\"woocommerce-fr_FR-e20617995f4ef68fe7e29c970faab75f.json\";i:70;s:55:\"woocommerce-fr_FR-49ba64346bc35c059097cb618b03311d.json\";i:71;s:55:\"woocommerce-fr_FR-5598a099319118a77b5e42860bea0251.json\";i:72;s:55:\"woocommerce-fr_FR-471a3ad765cae270d0a25210d8a53ab8.json\";i:73;s:55:\"woocommerce-fr_FR-3f1e25ac30728e4df6f092b159c47875.json\";i:74;s:55:\"woocommerce-fr_FR-d86a9d2b180b67f45930be95f4bf26a9.json\";i:75;s:55:\"woocommerce-fr_FR-64f0d663cfe62dfbb0c8052400e9d423.json\";i:76;s:55:\"woocommerce-fr_FR-98a8fb20e4e5f75bcfb26995589650e8.json\";i:77;s:55:\"woocommerce-fr_FR-f59fc99258fa76f6a00ffa61267dafed.json\";i:78;s:55:\"woocommerce-fr_FR-b473e3a32670309b75207dfacdaed4ae.json\";i:79;s:55:\"woocommerce-fr_FR-c79dfe679b87123eba25f5a0c688b1d5.json\";i:80;s:55:\"woocommerce-fr_FR-2b32bbc4963015931b7c821ff3ac61b9.json\";i:81;s:55:\"woocommerce-fr_FR-de3c7cc410529a47f2ffbea53e330c90.json\";i:82;s:55:\"woocommerce-fr_FR-5914770a01730d9ad61a73952929876b.json\";i:83;s:55:\"woocommerce-fr_FR-9742fcf551a793f6582d520a875dbc7f.json\";i:84;s:55:\"woocommerce-fr_FR-a6ff84a2a96718f5931b714ed4385ee4.json\";i:85;s:55:\"woocommerce-fr_FR-df3e60aed9b533efce4d8107618e3c54.json\";i:86;s:55:\"woocommerce-fr_FR-222ba99c0ab9979a199b79f82f1a52f9.json\";i:87;s:55:\"woocommerce-fr_FR-0a0188c1a49e75d2af172be062aac004.json\";i:88;s:55:\"woocommerce-fr_FR-a4c4feaa7af452f3806490e2597f9014.json\";i:89;s:55:\"woocommerce-fr_FR-fbeb96f8164c2403e759d3c4be2d472b.json\";i:90;s:26:\"woocommerce-fr_FR.l10n.php\";i:91;s:55:\"woocommerce-fr_FR-cb925680e1dc6c85b787fae72f51db1a.json\";i:92;s:55:\"woocommerce-fr_FR-75478d27162f9793b21b8408f1996bf1.json\";i:93;s:55:\"woocommerce-fr_FR-4722b63f6b580b10ebd10d293a0b6765.json\";i:94;s:55:\"woocommerce-fr_FR-f270a6b21bb6983ab88733006933d442.json\";i:95;s:55:\"woocommerce-fr_FR-31ef9d00b21b6f004ab50657c9191072.json\";i:96;s:55:\"woocommerce-fr_FR-897b981d0b3552c9eab81355b430d1df.json\";i:97;s:55:\"woocommerce-fr_FR-c086843b9cef0ab69403524492d4de1b.json\";i:98;s:55:\"woocommerce-fr_FR-0435896d3ed0c0479febff361aa0f68a.json\";i:99;s:55:\"woocommerce-fr_FR-e0bc0ec28810dbbc72532e28e7bcc58d.json\";i:100;s:55:\"woocommerce-fr_FR-46e8ea73a88e6e64e68acaec2c92bcca.json\";i:101;s:55:\"woocommerce-fr_FR-61ff17b10b4ff22e2725e50533ffc3a5.json\";i:102;s:55:\"woocommerce-fr_FR-12d195cdcdd08cd46e20ff463e2ae83e.json\";i:103;s:55:\"woocommerce-fr_FR-ea266705e57d8f22ce87a973e63973c4.json\";i:104;s:55:\"woocommerce-fr_FR-2b9ad1ee5266e82cfc566a86f6541d13.json\";i:105;s:55:\"woocommerce-fr_FR-74e5e424bcaed5f7c211729203f471df.json\";i:106;s:55:\"woocommerce-fr_FR-77210a6df64bbebe2414a649842dcb52.json\";i:107;s:55:\"woocommerce-fr_FR-f76aec99021d72e88afb0f04a532f79d.json\";i:108;s:55:\"woocommerce-fr_FR-1bb96e0bebe36fe6bd94960d3cdcfa7a.json\";i:109;s:55:\"woocommerce-fr_FR-aac8506b231a60cb1ad0ba315406097c.json\";i:110;s:55:\"woocommerce-fr_FR-29b0e56355106637676f77f1355b72db.json\";i:111;s:55:\"woocommerce-fr_FR-c4efd78f874161e4ccd3e4de7b666251.json\";i:112;s:55:\"woocommerce-fr_FR-c476dc5974245d3c32e0df2678e152e1.json\";i:113;s:55:\"woocommerce-fr_FR-5d95e88589c1e26aec733d311a5f6208.json\";i:114;s:55:\"woocommerce-fr_FR-279fa10060c1cf9b6f0ce3c1488f35ea.json\";i:115;s:55:\"woocommerce-fr_FR-3fc55720c999e9f80cee78098b82fd0c.json\";i:116;s:55:\"woocommerce-fr_FR-58a9ad52bee4a41c0b13e43941cc627e.json\";i:117;s:55:\"woocommerce-fr_FR-1dee949f3bc3eacc1513cb13c32c60bd.json\";i:118;s:55:\"woocommerce-fr_FR-2f278f06b0f8da97a92d1521751dca84.json\";i:119;s:55:\"woocommerce-fr_FR-99bba7c9e29ac75f0c5c84b12eb52ccf.json\";i:120;s:55:\"woocommerce-fr_FR-58eb230d6d2fe31c63044647ca8823cb.json\";i:121;s:55:\"woocommerce-fr_FR-9ea6effa3bb32821f8c8c1893f375b04.json\";i:122;s:55:\"woocommerce-fr_FR-077c5bb7545347e905aab54d7eb15734.json\";i:123;s:55:\"woocommerce-fr_FR-b41bb8ea325e450160deb70026229c62.json\";i:124;s:55:\"woocommerce-fr_FR-7db1c7831a17345b259dedf12fa5c4e7.json\";i:125;s:55:\"woocommerce-fr_FR-94c6bfb1ce20e99d1edc9207cf4673be.json\";i:126;s:55:\"woocommerce-fr_FR-21c97cf1edd07c594d1e7952ca60a50e.json\";i:127;s:55:\"woocommerce-fr_FR-4ead9007ae1ee6237e3aea212bc207d9.json\";i:128;s:55:\"woocommerce-fr_FR-aecb3c67a29773449e558eff12fa4238.json\";i:129;s:55:\"woocommerce-fr_FR-3eb1b9d6b8f7d2a59005ecc2cf46492f.json\";i:130;s:55:\"woocommerce-fr_FR-fdeb81b791b5fb3b71e8060816a37c11.json\";i:131;s:55:\"woocommerce-fr_FR-11819b527241962c70b08cf35d34a104.json\";i:132;s:55:\"woocommerce-fr_FR-2c06722f600263a208d0239e1bee3a8d.json\";i:133;s:55:\"woocommerce-fr_FR-3822e084584af73b3534ef184ec8d114.json\";i:134;s:55:\"woocommerce-fr_FR-04928f3cadfae9e0174101d5c19e28a1.json\";i:135;s:55:\"woocommerce-fr_FR-a203202ed09c67675354ffb2e6a13401.json\";i:136;s:55:\"woocommerce-fr_FR-30c7f6b9e786ba39013f7d90b417e417.json\";i:137;s:55:\"woocommerce-fr_FR-a39951e43e2c22f8b8575dc64b1adf6d.json\";i:138;s:55:\"woocommerce-fr_FR-051b948ebeb4e5c14867979a392b0fc3.json\";i:139;s:55:\"woocommerce-fr_FR-1a8f53117c16a3508e6cd4b45fc4c5f7.json\";i:140;s:55:\"woocommerce-fr_FR-b5eb9d1d4f5c11dc23eb22d8a5a026ff.json\";i:141;s:55:\"woocommerce-fr_FR-2fac73fdff6dd90596aa9a51631aeef3.json\";i:142;s:55:\"woocommerce-fr_FR-c65ba3a598d6018a8291ad8bc4225668.json\";i:143;s:55:\"woocommerce-fr_FR-af1de7be2ed0d3aba150f744bf0f82ae.json\";i:144;s:55:\"woocommerce-fr_FR-894003414e1a6c46b840c82e2f89f148.json\";i:145;s:55:\"woocommerce-fr_FR-0e8440226802a9e3adb55b2756a72274.json\";i:146;s:55:\"woocommerce-fr_FR-6d3357808773a680a4c1d4f63815860f.json\";i:147;s:55:\"woocommerce-fr_FR-9aa7620f7c09b927ab1e512da142330d.json\";i:148;s:55:\"woocommerce-fr_FR-7951b083e84d8324bfbc01920a7950b6.json\";i:149;s:55:\"woocommerce-fr_FR-507f1208a3dc15ee33256209b516fa76.json\";i:150;s:55:\"woocommerce-fr_FR-5d5623f50c74a7f52271ac233ab2f6bf.json\";i:151;s:55:\"woocommerce-fr_FR-42f875d1d5f4fc0dc6d5e7f27026c87d.json\";i:152;s:55:\"woocommerce-fr_FR-9c667de5e532bfd0bfb618907fd39d58.json\";i:153;s:55:\"woocommerce-fr_FR-56ac046978a89f98fa741a4dc37373f4.json\";i:154;s:55:\"woocommerce-fr_FR-62d404bf6e393bbb546940dd814b9f26.json\";i:155;s:55:\"woocommerce-fr_FR-25bbc2754ddee320a72967950691df90.json\";i:156;s:55:\"woocommerce-fr_FR-908ca6114f28255b8739e92d3bf6c198.json\";i:157;s:55:\"woocommerce-fr_FR-7861389540ce30157e63c9452aca49b5.json\";i:158;s:55:\"woocommerce-fr_FR-efe0fc0f9943be994639329f2ea6b076.json\";i:159;s:20:\"woocommerce-fr_FR.po\";i:160;s:55:\"woocommerce-fr_FR-fe8a75c3c92075e44f2e1b6aa2ffc1e1.json\";i:161;s:55:\"woocommerce-fr_FR-eedcababc7b65c05eaa9556915eb39b5.json\";i:162;s:55:\"woocommerce-fr_FR-b04131f0c7f4bd0670184286dcea650c.json\";i:163;s:55:\"woocommerce-fr_FR-5771b62744bce3727cc7578423dbffc6.json\";i:164;s:55:\"woocommerce-fr_FR-f2df68f6d4d5901de678e60cc278c159.json\";i:165;s:55:\"woocommerce-fr_FR-4960ed60135ea5260a9baabe3c0e60bb.json\";i:166;s:55:\"woocommerce-fr_FR-7d1c83d014474814d1024f6062f40ddc.json\";i:167;s:55:\"woocommerce-fr_FR-5baafde46dc216c3360fbafddd0986b6.json\";i:168;s:55:\"woocommerce-fr_FR-b95e3c9f215868cd25b8c5ad28106861.json\";i:169;s:55:\"woocommerce-fr_FR-1ff552fbfadf5ca30de94d0fb788108d.json\";i:170;s:55:\"woocommerce-fr_FR-a94d296015dbfc58ebdacf6bc560866e.json\";i:171;s:55:\"woocommerce-fr_FR-6b163e771738c554beb5fdb549b507c6.json\";i:172;s:55:\"woocommerce-fr_FR-7191abc3e5ae6aba1378c2d2b593e25a.json\";i:173;s:55:\"woocommerce-fr_FR-bd132b0816b6a1cf2bd394282b8994c4.json\";i:174;s:55:\"woocommerce-fr_FR-762d02a1afb327baad73e17fed1f08e6.json\";i:175;s:55:\"woocommerce-fr_FR-bfbeaf59a94409527195bc83600392b4.json\";i:176;s:55:\"woocommerce-fr_FR-9fd288fb160f5165b02dcd7e8e6743e7.json\";i:177;s:55:\"woocommerce-fr_FR-8ddaedc262566002ae5b7f852892b013.json\";i:178;s:55:\"woocommerce-fr_FR-9b585b1dd861f8b980f1e1f4de634039.json\";i:179;s:55:\"woocommerce-fr_FR-9df0c77ff5ef89f72faabf3d50ae98be.json\";i:180;s:55:\"woocommerce-fr_FR-013dea08856db161abf927a4e6199155.json\";i:181;s:55:\"woocommerce-fr_FR-5fbf25df535f461c9f131aa22e071b4a.json\";i:182;s:55:\"woocommerce-fr_FR-882736e017c8f1454484ee689148c0d3.json\";i:183;s:55:\"woocommerce-fr_FR-30eecad5aa15cff72eb58125ba5d85d7.json\";i:184;s:55:\"woocommerce-fr_FR-93580db0341766f81a11ac0086e8f847.json\";i:185;s:55:\"woocommerce-fr_FR-879d9567ab8f5fab82882a19120d7774.json\";i:186;s:55:\"woocommerce-fr_FR-31d590175c262701fd5d110e8269aedd.json\";i:187;s:55:\"woocommerce-fr_FR-ff1380fa8e9e3d530704e431ea4c7528.json\";i:188;s:55:\"woocommerce-fr_FR-100ddb5ec77b92120855823d508b2621.json\";i:189;s:55:\"woocommerce-fr_FR-81207f2e1817637c08b11cae7cc01024.json\";i:190;s:55:\"woocommerce-fr_FR-a0fac9bd8e1383f3c9dd13e437167139.json\";i:191;s:55:\"woocommerce-fr_FR-c694cf4a44b23f6c531a507792121e9e.json\";i:192;s:55:\"woocommerce-fr_FR-886530422d9a9bd5cc3f01ca3442c00e.json\";i:193;s:55:\"woocommerce-fr_FR-8ee8d726d9784374d27612e060ad197e.json\";i:194;s:55:\"woocommerce-fr_FR-9ddadd10c78683d1f77ef328a876511d.json\";i:195;s:55:\"woocommerce-fr_FR-80b8c3927dd55611294f2ed06b21d04f.json\";i:196;s:55:\"woocommerce-fr_FR-21db0a202cf860c0d667914e5c3ff04f.json\";i:197;s:55:\"woocommerce-fr_FR-1635acaa3eb10c788d39b8dba143ee8d.json\";i:198;s:55:\"woocommerce-fr_FR-47334b38fd482809419fbd389607b05e.json\";i:199;s:55:\"woocommerce-fr_FR-b78943e8ad17b8ddd6cc226def1e15df.json\";i:200;s:55:\"woocommerce-fr_FR-73a78fe6884e2ce9cd23e3af73a3b52f.json\";i:201;s:55:\"woocommerce-fr_FR-39d4b99786986c8785a60df484b86f21.json\";i:202;s:55:\"woocommerce-fr_FR-c5314d336f8c08c01d21d0a2321e8263.json\";i:203;s:55:\"woocommerce-fr_FR-307deb1043792dd104d07d926bde2852.json\";i:204;s:55:\"woocommerce-fr_FR-6b252174a3e91d81c283352772a134e4.json\";i:205;s:55:\"woocommerce-fr_FR-a5eaf2e219eebf99f469a6a08d0060c5.json\";i:206;s:55:\"woocommerce-fr_FR-753733dacbf958ee7471d7a26d5dd84e.json\";i:207;s:55:\"woocommerce-fr_FR-4ab6442e99b7c2a178f27791cdd43f56.json\";i:208;s:55:\"woocommerce-fr_FR-3d846a67871bcc8383e5c6f1024b8187.json\";i:209;s:55:\"woocommerce-fr_FR-a047c3f6dc8ba2aadd1a8f6ef6adc6ac.json\";i:210;s:55:\"woocommerce-fr_FR-b96517b2db03f7c61e573a05e38e268c.json\";i:211;s:55:\"woocommerce-fr_FR-9f0ea516940b0b3335f207678aac326e.json\";i:212;s:55:\"woocommerce-fr_FR-41c967d2b4e928033877e0063828c441.json\";i:213;s:55:\"woocommerce-fr_FR-b89c99dd4899a73f64f8a831a4d38164.json\";i:214;s:55:\"woocommerce-fr_FR-03d59a391e3fa87860de5bc40e402251.json\";i:215;s:55:\"woocommerce-fr_FR-96385beb4b4f37e93a4444cb9e8803bf.json\";i:216;s:55:\"woocommerce-fr_FR-76de108c0680bf620d1bde32df485ae5.json\";i:217;s:55:\"woocommerce-fr_FR-e416b6125c77a248e69f6df5e00abc0e.json\";i:218;s:55:\"woocommerce-fr_FR-d0258ce98e6189fd6bb704d043ce34fc.json\";i:219;s:55:\"woocommerce-fr_FR-3a7af9841984c09d0630c3716b17a97c.json\";i:220;s:55:\"woocommerce-fr_FR-027afe1bb7bb39bc3a7e39dc3bfdb439.json\";i:221;s:55:\"woocommerce-fr_FR-9db63b5c87e9e44dad1d40a287c8036f.json\";i:222;s:55:\"woocommerce-fr_FR-adde248a56aee83d96ba8b67f3d76914.json\";i:223;s:55:\"woocommerce-fr_FR-641fd4df4e377ec54b0d9354f920fbb3.json\";i:224;s:55:\"woocommerce-fr_FR-e834b177138aaafa00c1588787f005cb.json\";i:225;s:55:\"woocommerce-fr_FR-4177fc623b181279c609293ff5085ae0.json\";i:226;s:55:\"woocommerce-fr_FR-9fe0aaf46cc548f83696a2a2a4d3b220.json\";i:227;s:55:\"woocommerce-fr_FR-13b98984f6788c5a905ec4e2e2b9bb86.json\";i:228;s:55:\"woocommerce-fr_FR-14572ea42178218f02a7f3d6a88c91ea.json\";i:229;s:55:\"woocommerce-fr_FR-403dcd6a366f8d33e75b08cf7779b241.json\";i:230;s:55:\"woocommerce-fr_FR-c592f81bbbddcaca599353986858fe57.json\";i:231;s:55:\"woocommerce-fr_FR-05193a92b2d1838b5259ccc41e459d78.json\";i:232;s:55:\"woocommerce-fr_FR-9f86fcce972590b11091b30f1bab42de.json\";i:233;s:55:\"woocommerce-fr_FR-3819305314c698924728d966720aaca7.json\";i:234;s:55:\"woocommerce-fr_FR-4d4fa55da406b60dff2c54bd3e1bdf3a.json\";i:235;s:55:\"woocommerce-fr_FR-069b582ec1c2d638ffa35a6b5eabd9f1.json\";i:236;s:55:\"woocommerce-fr_FR-bd52b95024f757d0866faaa125f152f2.json\";i:237;s:55:\"woocommerce-fr_FR-d6056d63ae9915b6e6dee9a09b277858.json\";i:238;s:55:\"woocommerce-fr_FR-a857888aed6730e8bb4dd6a2d8b3d2ef.json\";i:239;s:55:\"woocommerce-fr_FR-690fb989ec5e02b17bed2da0083efbdf.json\";i:240;s:55:\"woocommerce-fr_FR-3d15c295dc4f6052bcee5acb181dc0d5.json\";i:241;s:55:\"woocommerce-fr_FR-1946967fff98663eed939b1b2e6e3340.json\";i:242;s:55:\"woocommerce-fr_FR-97022ed97b431dec2d18f580612470f8.json\";i:243;s:55:\"woocommerce-fr_FR-310aa1f58a8786a5c1345d8318a53e32.json\";i:244;s:55:\"woocommerce-fr_FR-81283264bb9ace29829c6d755f99b127.json\";i:245;s:55:\"woocommerce-fr_FR-f45b37583ed5b476c3f3d2a32f4de395.json\";i:246;s:55:\"woocommerce-fr_FR-969f290929cfa89f79981c270405c556.json\";i:247;s:55:\"woocommerce-fr_FR-a2420f3386419a4ba15f8b227399484a.json\";i:248;s:55:\"woocommerce-fr_FR-437fd0de081e2abc79b4baa55ec087a4.json\";i:249;s:55:\"woocommerce-fr_FR-2ce1ccfb028a87015cd02b9b1a2b40bc.json\";i:250;s:55:\"woocommerce-fr_FR-61879217cb86dca73d402b4a6834bf23.json\";i:251;s:55:\"woocommerce-fr_FR-3e376ec0adac031d29baa7e1204b6860.json\";i:252;s:55:\"woocommerce-fr_FR-ca84bc373fb564e573f6efc6b94f71f7.json\";i:253;s:55:\"woocommerce-fr_FR-5d44b68974722f8f33f1e09db8c8c52a.json\";i:254;s:55:\"woocommerce-fr_FR-4af982bf749b69f729f23ce8e76511b6.json\";i:255;s:55:\"woocommerce-fr_FR-06430b92a9c3d31960c3fa7daac1670e.json\";i:256;s:55:\"woocommerce-fr_FR-809dea67f83eb6ab2c3be36b9cb37563.json\";i:257;s:55:\"woocommerce-fr_FR-750143815c8f43588af17c98ace49c88.json\";i:258;s:55:\"woocommerce-fr_FR-cc81f776e921d7763aa7bc30036177f1.json\";i:259;s:55:\"woocommerce-fr_FR-9a365cfb083caccf7892aee2c1ab5d23.json\";i:260;s:55:\"woocommerce-fr_FR-5b86697c659cf20f2923fbcf16d84a91.json\";i:261;s:55:\"woocommerce-fr_FR-a0795582e2b29b03e38e7ba1a368ae57.json\";i:262;s:55:\"woocommerce-fr_FR-de92539e8e5af5b3e531b35314479783.json\";i:263;s:55:\"woocommerce-fr_FR-15a008f9d686fcc31f8006949bb3da16.json\";i:264;s:55:\"woocommerce-fr_FR-543b97cb96ec750877ca2483d93e7fab.json\";i:265;s:55:\"woocommerce-fr_FR-5d01323fef6997040e0487ea97c888de.json\";i:266;s:55:\"woocommerce-fr_FR-7fdaf32d435835d6f63f776731e6588f.json\";i:267;s:55:\"woocommerce-fr_FR-de90ea7046630a8ac03dc3df92869d2e.json\";i:268;s:55:\"woocommerce-fr_FR-455976efc6495e2a2dcc7c54cf31fb05.json\";i:269;s:55:\"woocommerce-fr_FR-9bdceb9c1529f02b3b8e547ac53dba1b.json\";i:270;s:55:\"woocommerce-fr_FR-ca1898f29b0927a43fa6ec96bdc2be47.json\";i:271;s:55:\"woocommerce-fr_FR-440e3f94950fd71495d4bcb332ee639f.json\";i:272;s:55:\"woocommerce-fr_FR-b89a01ddb2b6fc2148a2c4e1828ccb87.json\";i:273;s:55:\"woocommerce-fr_FR-3b957db33e488eb39035ec5e68557f2e.json\";i:274;s:55:\"woocommerce-fr_FR-ce3d3ec7111282dcdf3cfeb11c558277.json\";}s:11:\"destination\";s:49:\"/home/elegancebq/www/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:49:\"/home/elegancebq/www/wp-content/languages/plugins\";s:18:\"remote_destination\";s:50:\"/home/elegancebq/www/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:28:\"Traductions pour WooCommerce\";s:8:\"messages\";a:6:{i:0;s:59:\"Mise à jour de la traduction de WooCommerce (fr_FR)&#8230;\";i:1;s:121:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/woocommerce/9.7.1/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}","debug","2025-04-04 16:07:23","2025-04-04 16:07:12","133528864","136050032","wp-cron","1","0","54.37.121.239"),
("40","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-04 21:17:37","2025-04-04 21:17:26","128987944","130526216","wp-cron","1","0","54.37.121.239"),
("41","40","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-04 21:17:37","2025-04-04 21:17:26","129493736","130526216","wp-cron","1","0","54.37.121.239"),
("42","40","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-04 21:17:38","2025-04-04 21:17:26","129500216","130526216","wp-cron","1","0","54.37.121.239"),
("43","40","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-04 21:17:38","2025-04-04 21:17:26","129482208","130526216","wp-cron","1","0","54.37.121.239"),
("44","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-04 21:17:38","2025-04-04 21:17:26","129482464","130526216","wp-cron","1","0","54.37.121.239"),
("45","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-05 09:05:18","2025-04-05 09:05:15","128049320","128146920","http://www.elegance-piscines-spas.com/robots.txt","1","0","216.244.66.250"),
("46","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-05 09:08:22","2025-04-05 09:08:20","127679032","127821192","https://elegance-piscines-spas.com/feed/","1","0","51.222.253.15"),
("47","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-05 09:15:43","2025-04-05 09:15:36","128934328","129093336","wp-cron","1","0","54.37.121.239"),
("48","47","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-05 09:15:43","2025-04-05 09:15:36","129521544","129580928","wp-cron","1","0","54.37.121.239"),
("49","47","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-05 09:15:44","2025-04-05 09:15:36","129528024","129580928","wp-cron","1","0","54.37.121.239"),
("50","47","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-05 09:15:44","2025-04-05 09:15:36","129510016","129580928","wp-cron","1","0","54.37.121.239"),
("51","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-05 09:15:44","2025-04-05 09:15:36","129510272","129580928","wp-cron","1","0","54.37.121.239"),
("52","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-05 09:15:47","2025-04-05 09:15:46","128413416","128569752","wp-cron","1","0","54.37.121.239"),
("53","52","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-05 09:15:47","2025-04-05 09:15:46","128840480","128914344","wp-cron","1","0","54.37.121.239"),
("54","52","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:1;}","process-stop","2025-04-05 09:15:47","2025-04-05 09:15:46","128839280","128914344","wp-cron","1","0","54.37.121.239"),
("55","0","security-check-pro","start-scan","b:0;","process-start","2025-04-05 09:25:32","2025-04-05 09:25:31","128058840","128928984","wp-cron","1","0","54.37.121.239"),
("56","55","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-05 09:25:32","2025-04-05 09:25:31","128418656","128928984","wp-cron","1","0","54.37.121.239"),
("57","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-05 21:17:41","2025-04-05 21:17:20","128780816","130463264","wp-cron","1","0","54.37.121.239"),
("58","57","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-05 21:17:42","2025-04-05 21:17:20","129260528","130463264","wp-cron","1","0","54.37.121.239"),
("59","57","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-05 21:17:43","2025-04-05 21:17:20","129267328","130463264","wp-cron","1","0","54.37.121.239"),
("60","57","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-05 21:17:43","2025-04-05 21:17:20","129249320","130463264","wp-cron","1","0","54.37.121.239"),
("61","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-05 21:17:43","2025-04-05 21:17:20","129249576","130463264","wp-cron","1","0","54.37.121.239"),
("62","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-06 09:21:49","2025-04-06 09:21:47","128620992","128718592","https://elegance-piscines-spas.com/mentions-legales","1","0","40.77.167.24"),
("63","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-06 09:22:18","2025-04-06 09:21:49","129429584","130348512","wp-cron","1","0","54.37.121.239"),
("64","63","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-06 09:22:18","2025-04-06 09:21:49","129933264","130348512","wp-cron","1","0","54.37.121.239"),
("65","63","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-06 09:22:19","2025-04-06 09:21:49","129941104","130348512","wp-cron","1","0","54.37.121.239"),
("66","63","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-06 09:22:19","2025-04-06 09:21:49","129923096","130348512","wp-cron","1","0","54.37.121.239"),
("67","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-06 09:22:19","2025-04-06 09:21:49","129923352","130348512","wp-cron","1","0","54.37.121.239"),
("68","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-06 09:22:22","2025-04-06 09:22:22","128424024","128579608","wp-cron","1","0","54.37.121.239"),
("69","68","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-06 09:22:23","2025-04-06 09:22:22","128922376","128966560","wp-cron","1","0","54.37.121.239"),
("70","68","site-scanner","scan","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 536 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:536;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:536;}}}}s:6:\"cached\";b:0;}","process-stop","2025-04-06 09:22:23","2025-04-06 09:22:22","128921392","128966560","wp-cron","1","0","54.37.121.239"),
("71","0","site-scanner","scan-failure-client-error","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 536 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:536;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:536;}}}}s:6:\"cached\";b:0;}","warning","2025-04-06 09:22:23","2025-04-06 09:22:22","128906480","128966560","wp-cron","1","0","54.37.121.239"),
("72","0","security-check-pro","start-scan","b:0;","process-start","2025-04-06 09:28:49","2025-04-06 09:28:32","128659824","130425400","wp-cron","1","0","54.37.121.239"),
("73","72","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-06 09:28:49","2025-04-06 09:28:32","128667280","130425400","wp-cron","1","0","54.37.121.239"),
("74","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-06 09:32:55","2025-04-06 09:32:32","128535512","130232112","wp-cron","1","0","54.37.121.239"),
("75","74","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-06 09:32:55","2025-04-06 09:32:32","129090184","130232112","wp-cron","1","0","54.37.121.239"),
("76","74","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-06 09:32:55","2025-04-06 09:32:32","129096664","130232112","wp-cron","1","0","54.37.121.239"),
("77","74","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-06 09:32:55","2025-04-06 09:32:32","129078656","130232112","wp-cron","1","0","54.37.121.239"),
("78","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-06 09:32:55","2025-04-06 09:32:32","129078912","130232112","wp-cron","1","0","54.37.121.239"),
("79","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-06 21:16:53","2025-04-06 21:16:52","128204568","128801488","wp-cron","1","0","54.37.121.239"),
("80","79","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-06 21:16:53","2025-04-06 21:16:52","129105840","129164952","wp-cron","1","0","54.37.121.239"),
("81","79","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-06 21:16:54","2025-04-06 21:16:52","129112320","129164952","wp-cron","1","0","54.37.121.239"),
("82","79","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-06 21:16:54","2025-04-06 21:16:52","129094312","129164952","wp-cron","1","0","54.37.121.239"),
("83","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-06 21:16:54","2025-04-06 21:16:52","129094568","129164952","wp-cron","1","0","54.37.121.239"),
("84","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-07 09:17:35","2025-04-07 09:17:19","128258824","128835984","wp-cron","1","0","54.37.121.239"),
("85","84","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:15:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"66bce5b70cf8e52c2107923b6ce4438d0656d283\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-07 09:17:35","2025-04-07 09:17:19","128786872","128860736","wp-cron","1","0","54.37.121.239"),
("86","84","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-e632786d67c0bd95bf28523c03bedad7\";}","process-update","2025-04-07 09:17:36","2025-04-07 09:17:19","128846496","128948664","wp-cron","1","0","54.37.121.239"),
("87","84","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-07 09:17:36","2025-04-07 09:17:19","128828488","128948664","wp-cron","1","0","54.37.121.239"),
("88","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-07 09:17:36","2025-04-07 09:17:19","128828744","128948664","wp-cron","1","0","54.37.121.239"),
("89","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-07 09:22:25","2025-04-07 09:22:18","127407968","127484608","http://elegance-piscines-spas.com/","1","0","46.126.29.131"),
("90","0","security-check-pro","start-scan","b:0;","process-start","2025-04-07 09:29:05","2025-04-07 09:29:04","127717344","128355992","wp-cron","1","0","54.36.91.62"),
("91","90","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-07 09:29:05","2025-04-07 09:29:04","128142696","128355992","wp-cron","1","0","54.36.91.62"),
("92","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-07 13:24:07","2025-04-07 13:24:06","127082328","127170448","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("93","0","user_logging","post-status-changed::2,3236,new,publish","a:4:{s:7:\"user_id\";i:2;s:7:\"post_id\";i:3236;s:10:\"old_status\";s:3:\"new\";s:10:\"new_status\";s:7:\"publish\";}","notice","2025-04-07 13:27:25","2025-04-07 13:27:23","135194520","135285648","https://elegance-piscines-spas.com/wp-admin/admin-ajax.php","1","2","195.25.230.205"),
("94","0","version_management","install::plugin,wordpress-seo/wp-seo.php,24.8.1,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2025-04-07 13:27:52","2025-04-07 13:27:40","135809008","138007200","https://elegance-piscines-spas.com/wp-admin/admin-ajax.php","1","2","195.25.230.205"),
("95","0","user_logging","plugin-activated::wordpress-seo/wp-seo.php,","b:0;","notice","2025-04-07 13:29:08","2025-04-07 13:28:58","146780304","148270544","https://elegance-piscines-spas.com/wp-admin/plugins.php?_wpnonce=c2a96b9a63&action=activate&plugin=wordpress-seo%2Fwp-seo.php","1","2","195.25.230.205"),
("96","0","version_management","install::plugin,yith-woocommerce-catalog-mode/init.php,2.44.0,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2025-04-07 13:41:24","2025-04-07 13:41:19","145269168","145427944","https://elegance-piscines-spas.com/wp-admin/admin-ajax.php","1","2","195.25.230.205"),
("97","0","user_logging","plugin-activated::yith-woocommerce-catalog-mode/init.php,","b:0;","notice","2025-04-07 13:41:40","2025-04-07 13:41:36","147621976","148890960","https://elegance-piscines-spas.com/wp-admin/plugins.php?_wpnonce=853754f1a8&action=activate&plugin=yith-woocommerce-catalog-mode%2Finit.php","1","2","195.25.230.205"),
("98","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-07 21:29:22","2025-04-07 21:29:21","139311288","139828504","wp-cron","1","0","54.37.121.239"),
("99","98","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-07 21:29:22","2025-04-07 21:29:21","139855512","139926536","wp-cron","1","0","54.37.121.239"),
("100","98","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-07 21:29:23","2025-04-07 21:29:21","140214352","140333744","wp-cron","1","0","54.37.121.239"),
("101","98","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-07 21:29:23","2025-04-07 21:29:21","140195584","140333744","wp-cron","1","0","54.37.121.239"),
("102","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-07 21:29:23","2025-04-07 21:29:21","140195840","140333744","wp-cron","1","0","54.37.121.239"),
("103","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-08 07:09:51","2025-04-08 07:09:41","138065904","138153896","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("104","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-08 09:17:12","2025-04-08 09:17:05","139758632","141069512","wp-cron","1","0","54.37.121.239"),
("105","104","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-08 09:17:12","2025-04-08 09:17:05","140285816","141069512","wp-cron","1","0","54.37.121.239"),
("106","104","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-08 09:17:12","2025-04-08 09:17:05","140293016","141069512","wp-cron","1","0","54.37.121.239"),
("107","104","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-08 09:17:12","2025-04-08 09:17:05","140274248","141069512","wp-cron","1","0","54.37.121.239"),
("108","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-08 09:17:12","2025-04-08 09:17:05","140274504","141069512","wp-cron","1","0","54.37.121.239"),
("109","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-08 09:24:52","2025-04-08 09:24:50","138211832","138341600","https://elegance-piscines-spas.com/couleurs/ocean-wave-option/","1","0","86.202.129.131"),
("110","0","security-check-pro","start-scan","b:0;","process-start","2025-04-08 09:24:53","2025-04-08 09:24:52","138784752","139435224","wp-cron","1","0","54.37.121.239"),
("111","110","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-08 09:24:53","2025-04-08 09:24:52","139210104","139435224","wp-cron","1","0","54.37.121.239"),
("112","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-08 12:16:44","2025-04-08 12:16:43","138055600","138143800","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("113","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-08 13:08:39","2025-04-08 13:08:37","139294808","139383008","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("114","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-08 21:14:49","2025-04-08 21:14:49","42930672","43540032","wp-cron","1","0","54.37.121.239"),
("115","114","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-08 21:14:50","2025-04-08 21:14:49","43875968","43935752","wp-cron","1","0","54.37.121.239"),
("116","114","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-08 21:14:50","2025-04-08 21:14:49","43882448","43935752","wp-cron","1","0","54.37.121.239"),
("117","114","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-08 21:14:50","2025-04-08 21:14:49","43863680","43935752","wp-cron","1","0","54.37.121.239"),
("118","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-08 21:14:50","2025-04-08 21:14:49","43863936","43935752","wp-cron","1","0","54.37.121.239"),
("119","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-09 08:08:22","2025-04-09 08:08:21","40955080","41043328","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("120","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-09 09:16:14","2025-04-09 09:16:13","43287792","43621696","wp-cron","1","0","54.37.121.239"),
("121","120","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-09 09:16:15","2025-04-09 09:16:13","43918000","43978056","wp-cron","1","0","54.37.121.239"),
("122","120","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-09 09:16:15","2025-04-09 09:16:13","43924480","43978056","wp-cron","1","0","54.37.121.239"),
("123","120","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-09 09:16:15","2025-04-09 09:16:13","43905712","43978056","wp-cron","1","0","54.37.121.239"),
("124","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-09 09:16:15","2025-04-09 09:16:13","43905968","43978056","wp-cron","1","0","54.37.121.239"),
("125","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-09 09:26:58","2025-04-09 09:26:57","40939880","41068888","https://elegance-piscines-spas.com/piscine/","1","0","193.186.4.55"),
("126","0","security-check-pro","start-scan","b:0;","process-start","2025-04-09 09:26:58","2025-04-09 09:26:58","42862624","43510720","wp-cron","1","0","54.37.121.239"),
("127","126","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-09 09:26:59","2025-04-09 09:26:58","43222872","43510720","wp-cron","1","0","54.37.121.239"),
("128","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-09 21:16:35","2025-04-09 21:16:34","44103576","45998840","wp-cron","1","0","54.37.121.239"),
("129","128","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-09 21:16:35","2025-04-09 21:16:34","44686432","45998840","wp-cron","1","0","54.37.121.239"),
("130","128","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-09 21:16:36","2025-04-09 21:16:34","44694416","45998840","wp-cron","1","0","54.37.121.239"),
("131","128","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-09 21:16:36","2025-04-09 21:16:34","44675648","45998840","wp-cron","1","0","54.37.121.239"),
("132","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-09 21:16:36","2025-04-09 21:16:34","44675904","45998840","wp-cron","1","0","54.37.121.239"),
("133","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-10 09:15:12","2025-04-10 09:15:10","43093632","43738752","wp-cron","1","0","54.36.91.62"),
("134","133","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-10 09:15:12","2025-04-10 09:15:10","43617720","43738752","wp-cron","1","0","54.36.91.62"),
("135","133","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-10 09:15:12","2025-04-10 09:15:10","43624200","43738752","wp-cron","1","0","54.36.91.62"),
("136","133","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-10 09:15:12","2025-04-10 09:15:10","43605432","43738752","wp-cron","1","0","54.36.91.62"),
("137","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-10 09:15:12","2025-04-10 09:15:10","43605688","43738752","wp-cron","1","0","54.36.91.62"),
("138","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-10 09:28:06","2025-04-10 09:28:04","40968072","41097064","https://elegance-piscines-spas.com/fabricant/generation-piscine/","1","0","72.14.201.54"),
("139","0","security-check-pro","start-scan","b:0;","process-start","2025-04-10 09:28:06","2025-04-10 09:28:06","42739048","43388312","wp-cron","1","0","54.37.121.239"),
("140","139","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-10 09:28:07","2025-04-10 09:28:06","43099296","43388312","wp-cron","1","0","54.37.121.239"),
("141","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-10 21:27:07","2025-04-10 21:26:44","43590160","45246680","wp-cron","1","0","54.37.121.239"),
("142","141","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-10 21:27:08","2025-04-10 21:26:44","44180376","45246680","wp-cron","1","0","54.37.121.239"),
("143","141","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-10 21:27:09","2025-04-10 21:26:44","44187496","45246680","wp-cron","1","0","54.37.121.239"),
("144","141","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-10 21:27:09","2025-04-10 21:26:44","44168728","45246680","wp-cron","1","0","54.37.121.239"),
("145","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-10 21:27:09","2025-04-10 21:26:44","44168984","45246680","wp-cron","1","0","54.37.121.239"),
("146","0","user_logging","user-logged-in::2","a:1:{s:7:\"user_id\";i:2;}","notice","2025-04-11 09:09:02","2025-04-11 09:09:00","41851480","41939728","https://elegance-piscines-spas.com/wp-login.php?itsec-hb-token=BkoFH2o81","1","0","195.25.230.205"),
("147","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-11 09:14:44","2025-04-11 09:14:44","42967880","43130376","wp-cron","1","0","54.37.121.239"),
("148","147","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-11 09:14:45","2025-04-11 09:14:44","43754376","43814432","wp-cron","1","0","54.37.121.239"),
("149","147","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-11 09:14:45","2025-04-11 09:14:44","43760856","43814432","wp-cron","1","0","54.37.121.239"),
("150","147","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-11 09:14:45","2025-04-11 09:14:44","43742088","43814432","wp-cron","1","0","54.37.121.239"),
("151","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-11 09:14:45","2025-04-11 09:14:44","43742344","43814432","wp-cron","1","0","54.37.121.239"),
("152","0","security-check-pro","start-scan","b:0;","process-start","2025-04-11 09:24:45","2025-04-11 09:24:44","43011864","43224320","wp-cron","1","0","54.37.121.239"),
("153","152","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-11 09:24:45","2025-04-11 09:24:44","43372112","43484560","wp-cron","1","0","54.37.121.239"),
("154","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-11 09:28:05","2025-04-11 09:28:05","40067912","40169728","https://elegance-piscines-spas.com/dimension/450x220x150/","1","0","54.37.121.239"),
("155","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-11 21:15:23","2025-04-11 21:15:23","140528040","140665920","wp-cron","1","0","54.37.121.239"),
("156","155","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-11 21:15:23","2025-04-11 21:15:23","140965408","141039696","wp-cron","1","0","54.37.121.239"),
("157","155","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-11 21:15:24","2025-04-11 21:15:23","141389200","141508400","wp-cron","1","0","54.37.121.239"),
("158","155","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-11 21:15:24","2025-04-11 21:15:23","141370432","141508400","wp-cron","1","0","54.37.121.239"),
("159","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-11 21:15:24","2025-04-11 21:15:23","141370688","141508400","wp-cron","1","0","54.37.121.239"),
("160","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-12 09:15:41","2025-04-12 09:15:12","141865248","142882432","wp-cron","1","0","54.37.121.239"),
("161","160","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-12 09:15:41","2025-04-12 09:15:12","142371112","142882432","wp-cron","1","0","54.37.121.239"),
("162","160","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-12 09:15:41","2025-04-12 09:15:12","142378232","142882432","wp-cron","1","0","54.37.121.239"),
("163","160","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-12 09:15:41","2025-04-12 09:15:12","142359464","142882432","wp-cron","1","0","54.37.121.239"),
("164","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-12 09:15:41","2025-04-12 09:15:12","142359720","142882432","wp-cron","1","0","54.37.121.239"),
("165","0","security-check-pro","start-scan","b:0;","process-start","2025-04-12 09:24:44","2025-04-12 09:24:44","140407192","140620440","wp-cron","1","0","54.37.121.239"),
("166","165","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-12 09:24:45","2025-04-12 09:24:44","140831864","140944264","wp-cron","1","0","54.37.121.239"),
("167","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-12 09:28:19","2025-04-12 09:28:16","139902096","140032288","https://elegance-piscines-spas.com/wp-content/uploads/2018/10/piscine-coque-prado-plage-generationpiscines-8m10-4m.png","1","0","92.184.110.42"),
("168","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-12 21:17:57","2025-04-12 21:17:34","141332528","142851344","wp-cron","1","0","54.37.121.239"),
("169","168","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-12 21:17:58","2025-04-12 21:17:34","141878752","142851344","wp-cron","1","0","54.37.121.239"),
("170","168","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-12 21:17:58","2025-04-12 21:17:34","141886512","142851344","wp-cron","1","0","54.37.121.239"),
("171","168","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-12 21:17:58","2025-04-12 21:17:34","141867744","142851344","wp-cron","1","0","54.37.121.239"),
("172","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-12 21:17:58","2025-04-12 21:17:34","141868000","142851344","wp-cron","1","0","54.37.121.239"),
("173","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-13 09:18:25","2025-04-13 09:18:23","140786288","140952600","wp-cron","1","0","54.36.91.62"),
("174","173","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-13 09:18:26","2025-04-13 09:18:23","141333248","141393056","wp-cron","1","0","54.36.91.62"),
("175","173","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-13 09:18:26","2025-04-13 09:18:23","141339728","141393056","wp-cron","1","0","54.36.91.62"),
("176","173","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-13 09:18:26","2025-04-13 09:18:23","141320960","141393056","wp-cron","1","0","54.36.91.62"),
("177","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-13 09:18:26","2025-04-13 09:18:23","141321216","141393056","wp-cron","1","0","54.36.91.62"),
("178","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-13 09:28:29","2025-04-13 09:28:27","139889896","140020152","https://elegance-piscines-spas.com/autodiscover/autodiscover.xml","1","0","90.85.237.41"),
("179","0","security-check-pro","start-scan","b:0;","process-start","2025-04-13 09:28:30","2025-04-13 09:28:30","140465192","140966136","wp-cron","1","0","54.37.121.239"),
("180","179","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-13 09:28:31","2025-04-13 09:28:30","140824328","140966136","wp-cron","1","0","54.37.121.239"),
("181","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-13 21:15:23","2025-04-13 21:15:22","140529496","140667376","wp-cron","1","0","54.37.121.239"),
("182","181","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-13 21:15:24","2025-04-13 21:15:22","141390160","141449696","wp-cron","1","0","54.37.121.239"),
("183","181","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-13 21:15:24","2025-04-13 21:15:22","141396640","141449696","wp-cron","1","0","54.37.121.239"),
("184","181","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-13 21:15:24","2025-04-13 21:15:22","141377872","141449696","wp-cron","1","0","54.37.121.239"),
("185","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-13 21:15:24","2025-04-13 21:15:22","141378128","141449696","wp-cron","1","0","54.37.121.239"),
("186","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-14 09:15:33","2025-04-14 09:15:27","140933672","141099984","wp-cron","1","0","54.37.121.239"),
("187","186","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-14 09:15:33","2025-04-14 09:15:27","141396328","141470616","wp-cron","1","0","54.37.121.239");

INSERT IGNORE INTO `wpeps_itsec_logs` VALUES 
("188","186","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-14 09:15:34","2025-04-14 09:15:27","141454328","141573560","wp-cron","1","0","54.37.121.239"),
("189","186","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-14 09:15:34","2025-04-14 09:15:27","141435560","141573560","wp-cron","1","0","54.37.121.239"),
("190","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-14 09:15:34","2025-04-14 09:15:27","141435816","141573560","wp-cron","1","0","54.37.121.239"),
("191","0","security-check-pro","start-scan","b:0;","process-start","2025-04-14 09:28:02","2025-04-14 09:28:01","140466064","140968176","wp-cron","1","0","54.37.121.239"),
("192","191","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-14 09:28:02","2025-04-14 09:28:01","140825200","140968176","wp-cron","1","0","54.37.121.239"),
("193","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-14 09:35:36","2025-04-14 09:35:34","139933128","140063384","https://elegance-piscines-spas.com/fabricant/generation-piscine/","1","0","72.14.201.124"),
("194","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-14 21:20:11","2025-04-14 21:20:10","140510048","140969680","wp-cron","1","0","54.37.121.239"),
("195","194","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-14 21:20:11","2025-04-14 21:20:10","141410624","141470160","wp-cron","1","0","54.37.121.239"),
("196","194","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-14 21:20:12","2025-04-14 21:20:10","141417104","141470160","wp-cron","1","0","54.37.121.239"),
("197","194","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-14 21:20:12","2025-04-14 21:20:10","141398336","141470160","wp-cron","1","0","54.37.121.239"),
("198","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-14 21:20:12","2025-04-14 21:20:10","141398592","141470160","wp-cron","1","0","54.37.121.239"),
("199","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-15 09:15:15","2025-04-15 09:15:13","140871440","141035600","wp-cron","1","0","54.37.121.239"),
("200","199","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-15 09:15:15","2025-04-15 09:15:13","141359784","141434072","wp-cron","1","0","54.37.121.239"),
("201","199","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-15 09:15:15","2025-04-15 09:15:13","141417784","141537016","wp-cron","1","0","54.37.121.239"),
("202","199","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-15 09:15:15","2025-04-15 09:15:13","141399016","141537016","wp-cron","1","0","54.37.121.239"),
("203","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-15 09:15:15","2025-04-15 09:15:13","141399272","141537016","wp-cron","1","0","54.37.121.239"),
("204","0","security-check-pro","start-scan","b:0;","process-start","2025-04-15 09:33:47","2025-04-15 09:33:46","140375784","140810856","wp-cron","1","0","54.36.91.62"),
("205","204","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-15 09:33:47","2025-04-15 09:33:46","140734920","140847320","wp-cron","1","0","54.36.91.62"),
("206","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-15 09:35:37","2025-04-15 09:35:36","140036624","140085376","wp-cron","1","0","54.36.91.62"),
("207","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-15 21:14:46","2025-04-15 21:14:45","140800296","140972280","wp-cron","1","0","54.36.91.62"),
("208","207","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:5:\"6.7.2\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"db37c2032c869b83a18c598d95fb56ebfa2dd165\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-15 21:14:46","2025-04-15 21:14:45","141766408","141822784","wp-cron","1","0","54.36.91.62"),
("209","207","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-047cf292ace569c75c2595e548cc8b6e\";}","process-update","2025-04-15 21:14:46","2025-04-15 21:14:45","141772888","141822784","wp-cron","1","0","54.36.91.62"),
("210","207","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-15 21:14:46","2025-04-15 21:14:45","141754120","141822784","wp-cron","1","0","54.36.91.62"),
("211","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-15 21:14:46","2025-04-15 21:14:45","141754376","141822784","wp-cron","1","0","54.36.91.62"),
("212","0","version_management","update-core::6.8,6.7.2,auto","b:0;","notice","2025-04-16 08:10:17","2025-04-16 08:09:21","149340280","151771256","wp-cron","1","0","54.37.121.239"),
("213","0","version_management","auto-update","a:1:{s:4:\"core\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.8.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.8.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.8\";s:7:\"version\";s:3:\"6.8\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}s:6:\"result\";s:3:\"6.8\";s:4:\"name\";s:13:\"WordPress 6.8\";s:8:\"messages\";a:10:{i:0;s:31:\"Mise à jour vers WordPress 6.8\";i:1;s:109:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/release/fr_FR/wordpress-6.8.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:48:\"Vérification des fichiers décompressés&#8230;\";i:4;s:63:\"Préparation de l’installation de la dernière version&#8230;\";i:5;s:37:\"Activation du mode maintenance&#8230;\";i:6;s:38:\"Copie des fichiers nécessaires&#8230;\";i:7;s:41:\"Désactivation du mode maintenance&#8230;\";i:8;s:42:\"Mise à jour de la base de données&#8230;\";i:9;s:35:\"WordPress a bien été mis à jour.\";}}}}","debug","2025-04-16 08:10:21","2025-04-16 08:09:21","149980064","151771256","wp-cron","1","0","54.37.121.239"),
("214","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-16 09:15:06","2025-04-16 09:14:53","147577544","149047896","wp-cron","1","0","54.37.121.239"),
("215","214","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-16 09:15:06","2025-04-16 09:14:53","148119928","149047896","wp-cron","1","0","54.37.121.239"),
("216","214","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-16 09:15:07","2025-04-16 09:14:53","148126368","149047896","wp-cron","1","0","54.37.121.239"),
("217","214","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-16 09:15:07","2025-04-16 09:14:53","148107600","149047896","wp-cron","1","0","54.37.121.239"),
("218","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-16 09:15:07","2025-04-16 09:14:53","148107856","149047896","wp-cron","1","0","54.37.121.239"),
("219","0","security-check-pro","start-scan","b:0;","process-start","2025-04-16 09:25:20","2025-04-16 09:25:20","146679640","146898328","wp-cron","1","0","54.37.121.239"),
("220","219","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-16 09:25:21","2025-04-16 09:25:20","147062840","147174752","wp-cron","1","0","54.37.121.239"),
("221","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-16 09:36:59","2025-04-16 09:36:57","146042520","146156920","https://elegance-piscines-spas.com/.well-known/apple-app-site-association","1","0","69.171.231.112"),
("222","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-16 21:24:06","2025-04-16 21:23:55","147390432","147555464","wp-cron","1","0","54.37.121.239"),
("223","222","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-16 21:24:07","2025-04-16 21:23:55","148294664","148376240","wp-cron","1","0","54.37.121.239"),
("224","222","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-16 21:24:07","2025-04-16 21:23:55","148301104","148376240","wp-cron","1","0","54.37.121.239"),
("225","222","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-16 21:24:07","2025-04-16 21:23:55","148282336","148376240","wp-cron","1","0","54.37.121.239"),
("226","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-16 21:24:07","2025-04-16 21:23:55","148282592","148376240","wp-cron","1","0","54.37.121.239"),
("227","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-17 09:15:06","2025-04-17 09:15:03","147514880","147684024","wp-cron","1","0","54.36.91.62"),
("228","227","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-17 09:15:06","2025-04-17 09:15:03","148057904","148130424","wp-cron","1","0","54.36.91.62"),
("229","227","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-17 09:15:07","2025-04-17 09:15:03","148122400","148241184","wp-cron","1","0","54.36.91.62"),
("230","227","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-17 09:15:07","2025-04-17 09:15:03","148103632","148241184","wp-cron","1","0","54.36.91.62"),
("231","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-17 09:15:07","2025-04-17 09:15:03","148103888","148241184","wp-cron","1","0","54.36.91.62"),
("232","0","security-check-pro","start-scan","b:0;","process-start","2025-04-17 09:25:26","2025-04-17 09:25:25","147038088","147257344","wp-cron","1","0","54.37.121.239"),
("233","232","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-17 09:25:27","2025-04-17 09:25:25","147421288","147533200","wp-cron","1","0","54.37.121.239"),
("234","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-17 09:36:59","2025-04-17 09:36:59","145128424","145236088","https://elegance-piscines-spas.com/catalogue/bain-nordique/suede-stockholm/","1","0","54.37.121.239"),
("235","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-17 21:17:31","2025-04-17 21:17:30","146641456","146815192","wp-cron","1","0","54.37.121.239"),
("236","235","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-17 21:17:31","2025-04-17 21:17:30","147158128","147202400","wp-cron","1","0","54.37.121.239"),
("237","235","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-17 21:17:32","2025-04-17 21:17:30","147540344","147659096","wp-cron","1","0","54.37.121.239"),
("238","235","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-17 21:17:32","2025-04-17 21:17:30","147521576","147659096","wp-cron","1","0","54.37.121.239"),
("239","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-17 21:17:32","2025-04-17 21:17:30","147521832","147659096","wp-cron","1","0","54.37.121.239"),
("240","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-18 09:20:31","2025-04-18 09:20:00","142188304","143200640","wp-cron","1","0","54.37.121.239"),
("241","240","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-18 09:20:31","2025-04-18 09:20:00","142654008","143200640","wp-cron","1","0","54.37.121.239"),
("242","240","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-18 09:20:32","2025-04-18 09:20:00","142661208","143200640","wp-cron","1","0","54.37.121.239"),
("243","240","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-18 09:20:32","2025-04-18 09:20:00","142642440","143200640","wp-cron","1","0","54.37.121.239"),
("244","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-18 09:20:32","2025-04-18 09:20:00","142642696","143200640","wp-cron","1","0","54.37.121.239"),
("245","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-18 09:20:37","2025-04-18 09:20:37","140774096","140936504","wp-cron","1","0","54.37.121.239"),
("246","245","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-18 09:20:38","2025-04-18 09:20:37","141624872","141683936","wp-cron","1","0","54.37.121.239"),
("247","245","site-scanner","scan","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 534 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:534;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:534;}}}}s:6:\"cached\";b:0;}","process-stop","2025-04-18 09:20:38","2025-04-18 09:20:37","141623128","141683936","wp-cron","1","0","54.37.121.239"),
("248","0","site-scanner","scan-failure-client-error","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 534 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:534;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:534;}}}}s:6:\"cached\";b:0;}","warning","2025-04-18 09:20:38","2025-04-18 09:20:37","141608216","141683936","wp-cron","1","0","54.37.121.239"),
("249","0","security-check-pro","start-scan","b:0;","process-start","2025-04-18 09:24:45","2025-04-18 09:24:44","140727408","140944072","wp-cron","1","0","54.37.121.239"),
("250","249","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-18 09:24:45","2025-04-18 09:24:44","141087024","141199616","wp-cron","1","0","54.37.121.239"),
("251","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-18 09:30:03","2025-04-18 09:30:02","140757144","140894600","wp-cron","1","0","54.37.121.239"),
("252","251","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-18 09:30:03","2025-04-18 09:30:02","141274728","141319384","wp-cron","1","0","54.37.121.239"),
("253","251","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-18 09:30:03","2025-04-18 09:30:02","141634936","141752824","wp-cron","1","0","54.37.121.239"),
("254","251","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-18 09:30:03","2025-04-18 09:30:02","141616168","141752824","wp-cron","1","0","54.37.121.239"),
("255","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-18 09:30:03","2025-04-18 09:30:02","141616424","141752824","wp-cron","1","0","54.37.121.239"),
("256","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-18 09:40:24","2025-04-18 09:40:22","140173080","140304024","https://elegance-piscines-spas.com/couleurs/midnight-canon/page/2/","1","0","54.36.149.25"),
("257","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-18 21:18:15","2025-04-18 21:17:52","141476104","143111600","wp-cron","1","0","54.37.121.239"),
("258","257","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-18 21:18:16","2025-04-18 21:17:52","142025640","143111600","wp-cron","1","0","54.37.121.239"),
("259","257","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-18 21:18:16","2025-04-18 21:17:52","142032760","143111600","wp-cron","1","0","54.37.121.239"),
("260","257","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-18 21:18:16","2025-04-18 21:17:52","142013992","143111600","wp-cron","1","0","54.37.121.239"),
("261","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-18 21:18:16","2025-04-18 21:17:52","142014248","143111600","wp-cron","1","0","54.37.121.239"),
("262","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-19 09:16:42","2025-04-19 09:16:21","141527240","143249752","wp-cron","1","0","54.37.121.239"),
("263","262","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-19 09:16:43","2025-04-19 09:16:21","142058112","143249752","wp-cron","1","0","54.37.121.239"),
("264","262","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-19 09:16:43","2025-04-19 09:16:21","142065952","143249752","wp-cron","1","0","54.37.121.239"),
("265","262","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-19 09:16:43","2025-04-19 09:16:21","142047184","143249752","wp-cron","1","0","54.37.121.239"),
("266","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-19 09:16:43","2025-04-19 09:16:21","142047440","143249752","wp-cron","1","0","54.37.121.239"),
("267","0","security-check-pro","start-scan","b:0;","process-start","2025-04-19 09:27:26","2025-04-19 09:27:25","140730632","141380152","wp-cron","1","0","54.37.121.239"),
("268","267","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-19 09:27:26","2025-04-19 09:27:25","141155784","141380152","wp-cron","1","0","54.37.121.239"),
("269","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-19 09:41:00","2025-04-19 09:40:58","140144752","140275664","https://elegance-piscines-spas.com/wp-content/uploads/2019/02/SPA-PEIPS-SWIMSPA1-2-610x584.png","1","0","52.167.144.203"),
("270","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-19 21:15:51","2025-04-19 21:15:49","141231408","142759264","wp-cron","1","0","54.36.91.62"),
("271","270","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-19 21:15:52","2025-04-19 21:15:49","141780944","142759264","wp-cron","1","0","54.36.91.62"),
("272","270","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-19 21:15:52","2025-04-19 21:15:49","141787424","142759264","wp-cron","1","0","54.36.91.62"),
("273","270","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-19 21:15:52","2025-04-19 21:15:49","141768656","142759264","wp-cron","1","0","54.36.91.62"),
("274","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-19 21:15:52","2025-04-19 21:15:49","141768912","142759264","wp-cron","1","0","54.36.91.62"),
("275","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-20 09:17:02","2025-04-20 09:17:00","141181008","141449352","wp-cron","1","0","54.37.121.239"),
("276","275","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-20 09:17:02","2025-04-20 09:17:00","141711880","141782264","wp-cron","1","0","54.37.121.239"),
("277","275","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-20 09:17:03","2025-04-20 09:17:00","141771504","141873672","wp-cron","1","0","54.37.121.239"),
("278","275","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-20 09:17:03","2025-04-20 09:17:00","141752736","141873672","wp-cron","1","0","54.37.121.239"),
("279","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-20 09:17:03","2025-04-20 09:17:00","141752992","141873672","wp-cron","1","0","54.37.121.239"),
("280","0","security-check-pro","start-scan","b:0;","process-start","2025-04-20 09:25:10","2025-04-20 09:25:09","140709448","141354880","wp-cron","1","0","54.37.121.239"),
("281","280","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-20 09:25:11","2025-04-20 09:25:09","141134600","141354880","wp-cron","1","0","54.37.121.239"),
("282","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-20 09:41:12","2025-04-20 09:41:10","140132192","140263136","https://elegance-piscines-spas.com/volume-deau/1136-l/feed/","1","0","54.36.148.13"),
("283","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-20 21:15:48","2025-04-20 21:15:47","140783272","140953712","wp-cron","1","0","54.37.121.239"),
("284","283","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-20 21:15:49","2025-04-20 21:15:47","141647000","141705792","wp-cron","1","0","54.37.121.239"),
("285","283","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-20 21:15:49","2025-04-20 21:15:47","141653480","141705792","wp-cron","1","0","54.37.121.239"),
("286","283","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-20 21:15:49","2025-04-20 21:15:47","141634712","141705792","wp-cron","1","0","54.37.121.239"),
("287","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-20 21:15:49","2025-04-20 21:15:47","141634968","141705792","wp-cron","1","0","54.37.121.239"),
("288","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-21 09:18:18","2025-04-21 09:18:16","141183432","141451024","wp-cron","1","0","54.37.121.239"),
("289","288","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-21 09:18:18","2025-04-21 09:18:16","141772992","141832056","wp-cron","1","0","54.37.121.239"),
("290","288","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-21 09:18:19","2025-04-21 09:18:16","141779472","141832056","wp-cron","1","0","54.37.121.239"),
("291","288","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-21 09:18:19","2025-04-21 09:18:16","141760704","141832056","wp-cron","1","0","54.37.121.239"),
("292","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-21 09:18:19","2025-04-21 09:18:16","141760960","141832056","wp-cron","1","0","54.37.121.239"),
("293","0","security-check-pro","start-scan","b:0;","process-start","2025-04-21 09:33:45","2025-04-21 09:33:44","140710200","141354880","wp-cron","1","0","54.37.121.239"),
("294","293","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-21 09:33:45","2025-04-21 09:33:44","141135352","141354880","wp-cron","1","0","54.37.121.239"),
("295","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-21 09:44:59","2025-04-21 09:44:56","139461440","139592384","https://elegance-piscines-spas.com/.well-known/assetlinks.json","1","0","31.13.115.113"),
("296","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-21 21:35:36","2025-04-21 21:35:30","140954728","141621512","wp-cron","1","0","54.36.91.62"),
("297","296","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:129:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"http://elegance-piscines-spas.com\"\";}}","process-update","2025-04-21 21:35:36","2025-04-21 21:35:30","141924216","141983008","wp-cron","1","0","54.36.91.62"),
("298","296","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-21 21:35:37","2025-04-21 21:35:30","141930696","141983008","wp-cron","1","0","54.36.91.62"),
("299","296","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-21 21:35:37","2025-04-21 21:35:30","141911928","141983008","wp-cron","1","0","54.36.91.62"),
("300","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:33:\"http://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-21 21:35:37","2025-04-21 21:35:30","141912184","141983008","wp-cron","1","0","54.36.91.62"),
("301","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-22 09:15:42","2025-04-22 09:15:40","141123088","141288064","wp-cron","1","0","54.37.121.239"),
("302","301","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-22 09:15:43","2025-04-22 09:15:40","141614048","141687592","wp-cron","1","0","54.37.121.239"),
("303","301","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-22 09:15:43","2025-04-22 09:15:40","141673672","141775840","wp-cron","1","0","54.37.121.239"),
("304","301","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-22 09:15:43","2025-04-22 09:15:40","141654904","141775840","wp-cron","1","0","54.37.121.239"),
("305","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-22 09:15:43","2025-04-22 09:15:40","141655160","141775840","wp-cron","1","0","54.37.121.239"),
("306","0","security-check-pro","start-scan","b:0;","process-start","2025-04-22 09:29:51","2025-04-22 09:29:51","140625800","141273816","wp-cron","1","0","54.36.91.62"),
("307","306","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-22 09:29:52","2025-04-22 09:29:51","141050952","141273816","wp-cron","1","0","54.36.91.62"),
("308","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-22 09:46:52","2025-04-22 09:46:49","140144104","140275032","https://elegance-piscines-spas.com/wp-content/plugins/suretriggers/readme.txt","1","0","185.81.128.21"),
("309","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-22 21:20:07","2025-04-22 21:19:48","141466576","143238528","wp-cron","1","0","54.37.121.239"),
("310","309","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-22 21:20:07","2025-04-22 21:19:48","142016112","143238528","wp-cron","1","0","54.37.121.239"),
("311","309","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-22 21:20:08","2025-04-22 21:19:48","142022592","143238528","wp-cron","1","0","54.37.121.239"),
("312","309","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-22 21:20:08","2025-04-22 21:19:48","142003824","143238528","wp-cron","1","0","54.37.121.239"),
("313","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-22 21:20:08","2025-04-22 21:19:48","142004080","143238528","wp-cron","1","0","54.37.121.239"),
("314","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-23 09:16:12","2025-04-23 09:15:18","142965472","143596880","wp-cron","1","0","54.37.121.239"),
("315","314","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-23 09:16:12","2025-04-23 09:15:18","143499104","143596880","wp-cron","1","0","54.37.121.239"),
("316","314","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-23 09:16:13","2025-04-23 09:15:18","143557816","143659784","wp-cron","1","0","54.37.121.239"),
("317","314","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-23 09:16:13","2025-04-23 09:15:18","143539048","143659784","wp-cron","1","0","54.37.121.239"),
("318","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-23 09:16:13","2025-04-23 09:15:18","143539304","143659784","wp-cron","1","0","54.37.121.239"),
("319","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-23 09:16:39","2025-04-23 09:16:38","142262120","142423576","wp-cron","1","0","54.37.121.239"),
("320","319","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-23 09:16:39","2025-04-23 09:16:38","143117408","143175832","wp-cron","1","0","54.37.121.239"),
("321","319","site-scanner","scan","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 513 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:513;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:513;}}}}s:6:\"cached\";b:0;}","process-stop","2025-04-23 09:16:40","2025-04-23 09:16:38","143115624","143175832","wp-cron","1","0","54.37.121.239"),
("322","0","site-scanner","scan-failure-client-error","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;s:45:\"Exceeded rate limit. Please wait 513 seconds.\";}}s:10:\"error_data\";a:1:{s:19:\"rate_limit_exceeded\";a:2:{s:4:\"wait\";i:513;s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";}}s:18:\"\0*\0additional_data\";a:1:{s:19:\"rate_limit_exceeded\";a:1:{i:0;a:1:{s:4:\"wait\";i:513;}}}}s:6:\"cached\";b:0;}","warning","2025-04-23 09:16:40","2025-04-23 09:16:38","143100712","143175832","wp-cron","1","0","54.37.121.239"),
("323","0","security-check-pro","start-scan","b:0;","process-start","2025-04-23 09:26:09","2025-04-23 09:26:08","142566040","143135912","wp-cron","1","0","54.37.121.239"),
("324","323","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-23 09:26:09","2025-04-23 09:26:08","142925328","143135912","wp-cron","1","0","54.37.121.239"),
("325","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-23 09:26:29","2025-04-23 09:26:08","143060024","144759856","wp-cron","1","0","54.37.121.239"),
("326","325","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-23 09:26:29","2025-04-23 09:26:08","143582112","144759856","wp-cron","1","0","54.37.121.239"),
("327","325","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-23 09:26:29","2025-04-23 09:26:08","143588552","144759856","wp-cron","1","0","54.37.121.239"),
("328","325","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-23 09:26:29","2025-04-23 09:26:08","143569784","144759856","wp-cron","1","0","54.37.121.239"),
("329","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-23 09:26:29","2025-04-23 09:26:08","143570040","144759856","wp-cron","1","0","54.37.121.239"),
("330","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-23 09:57:26","2025-04-23 09:57:16","141517568","141645472","http://elegance-piscines-spas.com/website/wp-includes/wlwmanifest.xml","1","0","65.0.91.20"),
("331","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-23 21:15:13","2025-04-23 21:14:57","141779576","143383272","wp-cron","1","0","54.37.121.239"),
("332","331","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-23 21:15:13","2025-04-23 21:14:57","142321360","143383272","wp-cron","1","0","54.37.121.239"),
("333","331","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-23 21:15:14","2025-04-23 21:14:57","142327840","143383272","wp-cron","1","0","54.37.121.239"),
("334","331","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-23 21:15:14","2025-04-23 21:14:57","142309072","143383272","wp-cron","1","0","54.37.121.239"),
("335","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-23 21:15:14","2025-04-23 21:14:57","142309328","143383272","wp-cron","1","0","54.37.121.239"),
("336","0","version_management","auto-update","a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:4:\"core\";s:4:\"slug\";s:7:\"default\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-23 15:44:16\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:60:\"/home/elegancebq/www/wp-content/upgrade/wordpress-6.8-fr_fr/\";s:12:\"source_files\";a:72:{i:0;s:26:\"continents-cities-fr_FR.po\";i:1;s:43:\"fr_FR-e2791ba830489d23043be8650a22a22b.json\";i:2;s:43:\"fr_FR-e53526243551a102928735ec9eed4edf.json\";i:3;s:22:\"admin-network-fr_FR.po\";i:4;s:28:\"admin-network-fr_FR.l10n.php\";i:5;s:43:\"fr_FR-68f2cec7514bf8563c723a4d675fcfe6.json\";i:6;s:43:\"fr_FR-1c4303f02ff93b290e9faad991eeb06f.json\";i:7;s:43:\"fr_FR-e2e4c4b80f3adf2c70b431bfdb1b4872.json\";i:8;s:43:\"fr_FR-ca28138671823450e87dfd354f7afc6b.json\";i:9;s:43:\"fr_FR-50278328b502f4eb3f2b8b7ab49324a1.json\";i:10;s:43:\"fr_FR-f70806bf0c7d62f2908bd5a1c3fe4efc.json\";i:11;s:14:\"fr_FR.l10n.php\";i:12;s:43:\"fr_FR-2c5d274ea625dd91556554ad82901529.json\";i:13;s:43:\"fr_FR-49c6d4acf36cf3aca9f0b2a77617304f.json\";i:14;s:43:\"fr_FR-7d5ca435e60d92f024d46c9257aaa0f7.json\";i:15;s:43:\"fr_FR-6025add6bde16aaeb12787d250f9b414.json\";i:16;s:43:\"fr_FR-4bfa11da57ff2600004bb500368247f4.json\";i:17;s:43:\"fr_FR-270d72d1cff17227d37f3244759cbecb.json\";i:18;s:43:\"fr_FR-a25d1cc7bf7ca0b4e114f6bea64943f4.json\";i:19;s:43:\"fr_FR-9d47a87c240c1d10701cd6a02b28aa1b.json\";i:20;s:43:\"fr_FR-daeb084aab42199d26393a56c3465bc0.json\";i:21;s:43:\"fr_FR-81c889563f09dd13de1701135dc62941.json\";i:22;s:43:\"fr_FR-7436b7ee9e4f11ac0d618d8cc886eb66.json\";i:23;s:43:\"fr_FR-7f13c36c641b114bf18cd0bcc9ecc7e0.json\";i:24;s:43:\"fr_FR-60d06fac6f98e8e8f0ec5a945738b660.json\";i:25;s:43:\"fr_FR-0eebe503220d4a00341eb011b92769b4.json\";i:26;s:43:\"fr_FR-93882e8f9976382d7f724ac595ed7151.json\";i:27;s:43:\"fr_FR-1780a2033cf98d69ce13c2e5c8510004.json\";i:28;s:20:\"admin-fr_FR.l10n.php\";i:29;s:43:\"fr_FR-529362903a5a05b34b06b5e793fb4cf8.json\";i:30;s:43:\"fr_FR-7c90cd4398ee2d9d3628c387a87a70e5.json\";i:31;s:43:\"fr_FR-28b3c3d595952907e08d98287077426c.json\";i:32;s:43:\"fr_FR-aabfce98c410957228848dc581e3c420.json\";i:33;s:43:\"fr_FR-0cc31205f20441b3df1d1b46100f6b8d.json\";i:34;s:43:\"fr_FR-77fdfadaf2e1ca3a027d1956b910bc50.json\";i:35;s:43:\"fr_FR-f8f49d9fc4a9cf7d78ec99285417bd9c.json\";i:36;s:43:\"fr_FR-4a38fe1c0c45989e44682ba6109d9f46.json\";i:37;s:14:\"admin-fr_FR.po\";i:38;s:8:\"fr_FR.po\";i:39;s:43:\"fr_FR-c31d5f185753910c14afebc6deb2ce24.json\";i:40;s:43:\"fr_FR-a2796e57f680e25d84c4b352ee6d7280.json\";i:41;s:43:\"fr_FR-947c76bb5095da30e16668eec15406b2.json\";i:42;s:43:\"fr_FR-8240df461220d1d3a028a9a4c5652a5b.json\";i:43;s:43:\"fr_FR-17179a5f2930647c89151e365f843b6e.json\";i:44;s:26:\"continents-cities-fr_FR.mo\";i:45;s:43:\"fr_FR-1d17475f620f63a92e2c5d2681c51ee8.json\";i:46;s:43:\"fr_FR-9c3519f4870fac83dc0dbf18cb6bd4c4.json\";i:47;s:43:\"fr_FR-803bf1ce2131e13efc590c1bc47851fc.json\";i:48;s:43:\"fr_FR-2617ce121227a46077ede6c69aa9fcb5.json\";i:49;s:43:\"fr_FR-f575f481034e90e21d832e415fd95fcf.json\";i:50;s:43:\"fr_FR-bf0f094965d3d4a95b47babcb35fc136.json\";i:51;s:22:\"admin-network-fr_FR.mo\";i:52;s:43:\"fr_FR-8860e58c20c6a2ab5876a0f07be43bd9.json\";i:53;s:43:\"fr_FR-a9dc201dcd011fe71849743133052619.json\";i:54;s:43:\"fr_FR-5251f7623766a714c8207c7edb938628.json\";i:55;s:43:\"fr_FR-9b256ea9cd54df92095e04c76758ceb0.json\";i:56;s:43:\"fr_FR-1a0cd6a7128913b15c1a10dd68951869.json\";i:57;s:43:\"fr_FR-440127dd25bde48a531ded36f33e927b.json\";i:58;s:43:\"fr_FR-ac23eee47530ac63a1178c827db28087.json\";i:59;s:43:\"fr_FR-bf23b24175490c2e46aaf92ff6a0c70f.json\";i:60;s:14:\"admin-fr_FR.mo\";i:61;s:8:\"fr_FR.mo\";i:62;s:43:\"fr_FR-81d6f084cb273e02e15b01bd9ece87f7.json\";i:63;s:43:\"fr_FR-1bba9045bb07c89671c88a3f328548e8.json\";i:64;s:43:\"fr_FR-7289286ed59e90a8f36ae797df62220b.json\";i:65;s:43:\"fr_FR-569e85ef168299eb8c8f24d8ef8c8a78.json\";i:66;s:32:\"continents-cities-fr_FR.l10n.php\";i:67;s:43:\"fr_FR-0ce75ad2f775d1cac9696967d484808c.json\";i:68;s:43:\"fr_FR-7233008897033de5ee0d14f86a42a65a.json\";i:69;s:43:\"fr_FR-7b74c8457eaa7fcc50db41b431f8a003.json\";i:70;s:43:\"fr_FR-2b390f85a3048c5b4255fb45960b6514.json\";i:71;s:43:\"fr_FR-320f4ad9792aaa6dedb1e71cbdf85d57.json\";}s:11:\"destination\";s:41:\"/home/elegancebq/www/wp-content/languages\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:41:\"/home/elegancebq/www/wp-content/languages\";s:18:\"remote_destination\";s:42:\"/home/elegancebq/www/wp-content/languages/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour WordPress\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de WordPress (fr_FR)&#8230;\";i:1;s:105:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/core/6.8/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}","debug","2025-04-24 04:04:01","2025-04-24 04:03:50","146564504","147751920","wp-cron","1","0","54.37.121.239"),
("337","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-24 09:15:34","2025-04-24 09:15:32","141052080","141216096","wp-cron","1","0","54.37.121.239"),
("338","337","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-24 09:15:34","2025-04-24 09:15:32","141903200","141962424","wp-cron","1","0","54.37.121.239"),
("339","337","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-24 09:15:35","2025-04-24 09:15:32","141909680","141962424","wp-cron","1","0","54.37.121.239"),
("340","337","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-24 09:15:35","2025-04-24 09:15:32","141890912","141962424","wp-cron","1","0","54.37.121.239"),
("341","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-24 09:15:35","2025-04-24 09:15:32","141891168","141962424","wp-cron","1","0","54.37.121.239"),
("342","0","security-check-pro","start-scan","b:0;","process-start","2025-04-24 09:28:19","2025-04-24 09:27:50","146398624","147193704","wp-cron","1","0","54.37.121.239"),
("343","342","security-check-pro","start-scan","a:2:{s:6:\"status\";i:404;s:4:\"body\";N;}","process-stop","2025-04-24 09:28:19","2025-04-24 09:27:50","146394728","147193704","wp-cron","1","0","54.37.121.239"),
("344","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:2:{i:0;s:6:\"digest\";i:1;s:14:\"inactive-users\";}s:6:\"silent\";b:0;}","debug","2025-04-24 10:05:41","2025-04-24 10:05:25","140459520","140589712","https://elegance-piscines-spas.com/catalogue/piscine/inizan-fiquerolles/","1","0","66.249.66.40"),
("345","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-24 21:17:31","2025-04-24 21:17:30","141064480","141235360","wp-cron","1","0","54.37.121.239"),
("346","345","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-24 21:17:32","2025-04-24 21:17:30","141927808","141986760","wp-cron","1","0","54.37.121.239"),
("347","345","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-24 21:17:32","2025-04-24 21:17:30","141934288","141986760","wp-cron","1","0","54.37.121.239"),
("348","345","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-24 21:17:32","2025-04-24 21:17:30","141915520","141986760","wp-cron","1","0","54.37.121.239"),
("349","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-24 21:17:32","2025-04-24 21:17:30","141915776","141986760","wp-cron","1","0","54.37.121.239"),
("350","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-25 09:19:13","2025-04-25 09:18:55","141819144","143435696","wp-cron","1","0","54.37.121.239"),
("351","350","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3.18.3\";s:29:\"yith-woocommerce-catalog-mode\";s:6:\"2.44.0\";s:13:\"wordpress-seo\";s:6:\"24.8.1\";}s:6:\"themes\";a:3:{s:10:\"Divi-child\";s:0:\"\";s:4:\"Divi\";s:6:\"4.27.4\";s:16:\"twentytwentyfive\";s:3:\"1.1\";}s:11:\"mutedIssues\";a:0:{}}s:7:\"headers\";a:3:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";s:13:\"Authorization\";s:130:\"X-KeySignature signature=\"6c6972e367016d98382ec46c29ef7d3337efdb2e\" username=\"anewstory\" site=\"https://elegance-piscines-spas.com\"\";}}","process-update","2025-04-25 09:19:13","2025-04-25 09:18:55","142349672","143435696","wp-cron","1","0","54.37.121.239"),
("352","350","site-scanner","scan","a:3:{s:6:\"action\";s:16:\"caching-response\";s:6:\"mapped\";a:2:{s:7:\"private\";b:1;s:7:\"max-age\";s:4:\"3600\";}s:9:\"cache_key\";s:51:\"itsec-site-scanner-46eb62eee197cd2150adf9cf8846a935\";}","process-update","2025-04-25 09:19:14","2025-04-25 09:18:55","142356872","143435696","wp-cron","1","0","54.37.121.239"),
("353","350","site-scanner","scan","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2025-04-25 09:19:14","2025-04-25 09:18:55","142338104","143435696","wp-cron","1","0","54.37.121.239"),
("354","0","site-scanner","clean","a:2:{s:7:\"results\";a:4:{s:3:\"url\";s:34:\"https://elegance-piscines-spas.com\";s:7:\"version\";s:3:\"1.1\";s:7:\"entries\";a:2:{s:9:\"blacklist\";a:1:{i:0;a:3:{s:14:\"report_details\";s:89:\"https://transparencyreport.google.com/safe-browsing/search?url=elegance-piscines-spas.com\";s:6:\"status\";s:5:\"clean\";s:6:\"vendor\";a:2:{s:4:\"slug\";s:6:\"google\";s:5:\"label\";s:20:\"Google Safe Browsing\";}}}s:15:\"vulnerabilities\";a:0:{}}s:6:\"errors\";a:0:{}}s:6:\"cached\";b:0;}","notice","2025-04-25 09:19:14","2025-04-25 09:18:55","142338360","143435696","wp-cron","1","0","54.37.121.239"),
("355","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2025-04-25 09:19:28","2025-04-25 09:19:25","141417016","141580616","wp-cron","1","0","54.37.121.239"),
("356","355","site-scanner","scan","a:4:{s:5:\"route\";s:8:\"api/scan\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:4:{s:9:\"wordpress\";s:3:\"6.8\";s:7:\"plugins\";a:17:{s:22:\"advanced-custom-fields\";s:6:\"6.3.12\";s:7:\"akismet\";s:5:\"5.3.7\";s:14:\"complianz-gdpr\";s:5:\"7.4.0\";s:16:\"dg-divi-carousel\";s:6:\"2.0.24\";s:14:\"divi-essential\";s:6:\"4.9.11\";s:14:\"duplicator-pro\";s:8:\"4.5.21.2\";s:7:\"folders\";s:5:\"3.0.6\";s:1:\".\";s:5:\"1.7.2\";s:27:\"woocommerce-products-filter\";s:7:\"1.3.6.6\";s:11:\"ninja-forms\";s:6:\"3.10.0\";s:17:\"ninja-forms-style\";s:6:\"3.0.30\";s:20:\"ithemes-security-pro\";s:5:\"8.5.4\";s:25:\"themify-wc-product-filter\";s:5:\"1.5.4\";s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wp-rocket\";s:6:\"3